/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.inventory.input;

import com.stal111.forbidden_arcanus.common.block.entity.forge.HephaestusForgeBlockEntity;
import com.stal111.forbidden_arcanus.common.inventory.InputType;
import com.stal111.forbidden_arcanus.common.inventory.input.HephaestusForgeInput;
import java.util.Map;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.valhelsia.valhelsia_core.common.util.ItemStackUtils;

public class EnchantmentInput
implements HephaestusForgeInput {
    @Override
    public boolean canInput(InputType inputType, ItemStack stack) {
        return inputType == InputType.EXPERIENCE && stack.m_41793_();
    }

    @Override
    public int getInputValue(InputType inputType, ItemStack stack, RandomSource random) {
        int xp = this.getEnchantmentXp(stack);
        if (xp <= 0) {
            return 0;
        }
        int i = (int)Math.ceil((double)xp / 2.0);
        return i + random.m_188503_(i);
    }

    @Override
    public void finishInput(InputType inputType, ItemStack stack, HephaestusForgeBlockEntity tileEntity, int slot, int inputValue) {
        if (inputValue != 0) {
            tileEntity.m_6836_(slot, ItemStackUtils.removeEnchantments((ItemStack)stack));
        }
    }

    private int getEnchantmentXp(ItemStack stack) {
        int xp = 0;
        Map map = EnchantmentHelper.m_44831_((ItemStack)stack);
        for (Map.Entry entry : map.entrySet()) {
            Enchantment enchantment = (Enchantment)entry.getKey();
            Integer integer = (Integer)entry.getValue();
            if (enchantment.m_6589_()) continue;
            xp += enchantment.m_6183_(integer.intValue());
        }
        return xp;
    }
}

