/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.item;

import com.stal111.forbidden_arcanus.common.block.SoullessSandBlock;
import com.stal111.forbidden_arcanus.common.entity.lostsoul.SoulExtractable;
import com.stal111.forbidden_arcanus.core.init.ModBlocks;
import com.stal111.forbidden_arcanus.core.init.ModItems;
import com.stal111.forbidden_arcanus.core.init.ModParticles;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class SoulExtractorItem
extends Item {
    private static final int USE_DURATION = 35;
    private static final String KEY_EXTRACTING_FROM_ENTITY = "ExtractingFromEntity";

    public SoulExtractorItem(Item.Properties properties) {
        super(properties);
    }

    @Nonnull
    public InteractionResult m_6225_(@Nonnull UseOnContext context) {
        Player player = context.m_43723_();
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        if (player == null || player.m_6144_()) {
            return InteractionResult.PASS;
        }
        if (this.isValidBlock(level, pos, player)) {
            player.m_6672_(context.m_43724_());
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        return super.m_6225_(context);
    }

    @Nonnull
    public ItemStack m_5922_(@Nonnull ItemStack stack, @Nonnull Level level, @Nonnull LivingEntity livingEntity) {
        Player player;
        if (!(livingEntity instanceof Player) || (player = (Player)livingEntity).m_6144_()) {
            return stack;
        }
        BlockPos pos = SoulExtractorItem.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY).m_82425_();
        if (!this.isValidBlock(level, pos, player)) {
            return stack;
        }
        RandomSource random = player.m_217043_();
        stack.m_41622_(1, (LivingEntity)player, playerEntity -> playerEntity.m_21166_(EquipmentSlot.MAINHAND));
        player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        for (int i = 0; i < 4; ++i) {
            level.m_7106_((ParticleOptions)ModParticles.SOUL.get(), (double)((float)pos.m_123341_() + random.m_188501_()), (double)(pos.m_123342_() + 1), (double)((float)pos.m_123343_() + random.m_188501_()), 1.0, 1.0, 1.0);
        }
        if (!level.m_5776_()) {
            level.m_46597_(pos, ((SoullessSandBlock)((Object)ModBlocks.SOULLESS_SAND.get())).m_49966_());
            level.m_7967_((Entity)new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 0.5, new ItemStack((ItemLike)ModItems.SOUL.get())));
        }
        return stack;
    }

    private boolean isValidBlock(Level level, BlockPos pos, Player player) {
        return level.m_7966_(player, pos) && level.m_8055_(pos).m_60713_(Blocks.f_50135_);
    }

    public void onUsingTick(ItemStack stack, LivingEntity livingEntity, int count) {
        BlockPos pos;
        Player player;
        if (!(livingEntity instanceof Player) || (player = (Player)livingEntity).m_6144_()) {
            livingEntity.m_5810_();
            return;
        }
        Level level = player.m_9236_();
        if (this.isValidBlock(level, pos = SoulExtractorItem.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY).m_82425_(), player) && player.m_217043_().m_188503_(6) == 1) {
            level.m_5898_(player, 2001, pos, Block.m_49956_((BlockState)level.m_8055_(pos)));
            return;
        }
    }

    @Nonnull
    public InteractionResult m_6880_(@Nonnull ItemStack stack, @Nonnull Player player, @Nonnull LivingEntity entity, @Nonnull InteractionHand usedHand) {
        Level level = player.m_9236_();
        if (entity instanceof SoulExtractable) {
            SoulExtractable soulExtractable = (SoulExtractable)entity;
            if (!level.m_5776_() && level.m_46467_() % 3L == 0L) {
                soulExtractable.setExtracting();
                if (!player.m_6117_()) {
                    soulExtractable.extractTick(player, entity);
                }
            }
        }
        return super.m_6880_(stack, player, entity, usedHand);
    }

    public int m_8105_(@Nonnull ItemStack stack) {
        return 35;
    }

    @Nonnull
    public UseAnim m_6164_(@Nonnull ItemStack stack) {
        return UseAnim.BOW;
    }

    public boolean m_6777_(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, Player player) {
        return !player.m_150110_().f_35937_;
    }

    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level level, List<Component> list, @Nonnull TooltipFlag flag) {
        list.add((Component)Component.m_237115_((String)"tooltip.forbidden_arcanus.soul_extractor").m_130940_(ChatFormatting.GRAY));
        super.m_7373_(stack, level, list, flag);
    }
}

