/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.loader;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.stal111.forbidden_arcanus.ForbiddenArcanus;
import com.stal111.forbidden_arcanus.common.block.entity.forge.ritual.Ritual;
import com.stal111.forbidden_arcanus.common.block.entity.forge.ritual.RitualEssences;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class RitualLoader
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static Map<ResourceLocation, Ritual> rituals = new HashMap<ResourceLocation, Ritual>();

    public RitualLoader() {
        super(GSON, "hephaestus_forge/rituals");
    }

    protected void apply(@Nonnull Map<ResourceLocation, JsonElement> object, @Nonnull ResourceManager resourceManager, @Nonnull ProfilerFiller profiler) {
        rituals.clear();
        for (Map.Entry<ResourceLocation, JsonElement> entry : object.entrySet()) {
            ResourceLocation resourceLocation = entry.getKey();
            if (resourceLocation.m_135815_().startsWith("_")) continue;
            try {
                Ritual ritual = this.deserializeRitual(resourceLocation, entry.getValue().getAsJsonObject());
                if (ritual == null) continue;
                rituals.put(resourceLocation, ritual);
            }
            catch (JsonParseException | IllegalArgumentException jsonParseException) {
                ForbiddenArcanus.LOGGER.error("Parsing error loading hephaestus forge input {}", (Object)resourceLocation, (Object)jsonParseException);
            }
        }
    }

    public static Ritual getRitual(ResourceLocation resourceLocation) {
        return rituals.get(resourceLocation);
    }

    public static List<Ritual> getRituals() {
        ArrayList<Ritual> rituals = new ArrayList<Ritual>();
        for (Map.Entry<ResourceLocation, Ritual> entry : RitualLoader.rituals.entrySet()) {
            rituals.add(entry.getValue());
        }
        return rituals;
    }

    public static void setRituals(Map<ResourceLocation, Ritual> rituals) {
        RitualLoader.rituals = rituals;
    }

    private Ritual deserializeRitual(ResourceLocation name, JsonObject jsonObject) {
        ItemStack hephaestusForgeInput = ItemStack.f_41583_;
        if (jsonObject.has("hephaestus_forge_item")) {
            hephaestusForgeInput = new ItemStack((ItemLike)this.deserializeItem(new ResourceLocation(GsonHelper.m_13906_((JsonObject)jsonObject, (String)"hephaestus_forge_item"))));
        }
        try {
            System.out.println(TagParser.m_129359_((String)GSON.toJson(jsonObject.get("result"))));
            ItemStack result = CraftingHelper.getItemStack((JsonObject)GsonHelper.m_13930_((JsonObject)jsonObject, (String)"result"), (boolean)true);
            return new Ritual(name, this.deserializeInputs(jsonObject), hephaestusForgeInput, result, this.deserializeEssences(jsonObject), new ResourceLocation("forbidden_arcanus", "textures/effect/magic_circle/absolute.png"), new ResourceLocation("forbidden_arcanus", "textures/effect/magic_circle/inner_protection.png"), 1200);
        }
        catch (CommandSyntaxException e) {
            e.printStackTrace();
            return null;
        }
    }

    private Map<Integer, Ingredient> deserializeInputs(JsonObject jsonObject) {
        HashMap<Integer, Ingredient> inputs = new HashMap<Integer, Ingredient>();
        JsonArray jsonArray = jsonObject.getAsJsonArray("inputs");
        for (int i = 0; i < jsonArray.size(); ++i) {
            JsonObject input = jsonArray.get(i).getAsJsonObject();
            ItemStack stack = CraftingHelper.getItemStack((JsonObject)input, (boolean)true);
            int slot = input.get("slot").getAsInt();
            if (inputs.containsKey(slot)) {
                throw new IllegalStateException("Slot " + slot + " was already assigned.");
            }
            inputs.put(slot, Ingredient.m_43927_((ItemStack[])new ItemStack[]{stack}));
        }
        return inputs;
    }

    private Item deserializeItem(ResourceLocation name) {
        Item item = (Item)ForgeRegistries.ITEMS.getValue(name);
        if (item == null) {
            ForbiddenArcanus.LOGGER.error("Item " + name + " does not exist.");
            throw new IllegalArgumentException();
        }
        return item;
    }

    private RitualEssences deserializeEssences(JsonObject jsonObject) {
        JsonObject essences = jsonObject.get("essences").getAsJsonObject();
        int aureal = GsonHelper.m_13824_((JsonObject)essences, (String)"aureal", (int)0);
        int corruption = GsonHelper.m_13824_((JsonObject)essences, (String)"corruption", (int)0);
        int souls = GsonHelper.m_13824_((JsonObject)essences, (String)"souls", (int)0);
        int blood = GsonHelper.m_13824_((JsonObject)essences, (String)"blood", (int)0);
        int experience = GsonHelper.m_13824_((JsonObject)essences, (String)"experience", (int)0);
        return new RitualEssences(aureal, corruption, souls, blood, experience);
    }
}

