/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.data.client;

import com.stal111.forbidden_arcanus.ForbiddenArcanus;
import com.stal111.forbidden_arcanus.common.block.ArcaneCrystalObeliskBlock;
import com.stal111.forbidden_arcanus.common.block.entity.clibano.ClibanoFireType;
import com.stal111.forbidden_arcanus.common.block.properties.ClibanoCenterType;
import com.stal111.forbidden_arcanus.common.block.properties.ClibanoSideType;
import com.stal111.forbidden_arcanus.common.block.properties.ModBlockStateProperties;
import com.stal111.forbidden_arcanus.common.block.properties.ObeliskPart;
import com.stal111.forbidden_arcanus.common.block.properties.PillarType;
import com.stal111.forbidden_arcanus.core.init.ModBlocks;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import net.valhelsia.valhelsia_core.core.data.ValhelsiaBlockStateProvider;

public class ModBlockStateProvider
extends ValhelsiaBlockStateProvider {
    public ModBlockStateProvider(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen, ForbiddenArcanus.REGISTRY_MANAGER, exFileHelper);
    }

    protected void registerStatesAndModels() {
        Arrays.asList(ModBlocks.OBSIDIAN_SKULL, ModBlocks.OBSIDIAN_WALL_SKULL, ModBlocks.ETERNAL_OBSIDIAN_SKULL, ModBlocks.ETERNAL_OBSIDIAN_WALL_SKULL, ModBlocks.THIN_CHERRY_LOG, ModBlocks.CLIBANO_MAIN_PART).forEach(this.getRemainingBlocks()::remove);
        this.getRemainingBlocks().removeIf(registryObject -> registryObject.get() instanceof WallSignBlock);
        this.take(block -> this.cubeAllCutout((Block)block, this.modLoc("block/arcane_crystal_ore/" + this.getName((Block)block)), this.modLoc("block/arcane_crystal_ore/arcane_crystal_ore_layer"), this.mcLoc("block/stone")), new RegistryObject[]{ModBlocks.ARCANE_CRYSTAL_ORE, ModBlocks.DEEPSLATE_ARCANE_CRYSTAL_ORE});
        this.take(block -> this.cubeAllCutout((Block)block, this.modLoc("block/runic_stone/" + this.getName((Block)block)), this.modLoc("block/runic_stone/rune_layer"), this.mcLoc("block/stone")), new RegistryObject[]{ModBlocks.RUNIC_STONE, ModBlocks.RUNIC_DEEPSLATE, ModBlocks.RUNIC_DARKSTONE});
        this.take(block -> this.cubeAllCutout((Block)block, this.modLoc("block/" + this.getName((Block)block)), this.modLoc("block/xpetrified_ore_layer"), this.modLoc("block/" + this.getName((Block)block))), new RegistryObject[]{ModBlocks.XPETRIFIED_ORE});
        this.take(block -> this.cubeColumn((Block)block, this.modLoc("block/cut_soulless_sandstone_side"), this.modLoc("block/cut_soulless_sandstone")), new RegistryObject[]{ModBlocks.CUT_SOULLESS_SANDSTONE});
        this.take(arg_0 -> ((ModBlockStateProvider)this).withExistingModel(arg_0), new RegistryObject[]{ModBlocks.UTREM_JAR, ModBlocks.NIPA, ModBlocks.PETRIFIED_ROOT, ModBlocks.HEPHAESTUS_FORGE, ModBlocks.ARCANE_DRAGON_EGG});
        this.take(this::randomRotation, new RegistryObject[]{ModBlocks.DARKSTONE});
        this.take(block -> this.simpleBlock((Block)block, (ModelFile)this.models().cross(this.getName((Block)block), this.modLoc("block/" + this.getName((Block)block)))), new RegistryObject[]{ModBlocks.YELLOW_ORCHID});
        this.take(block -> this.pixieUtremJarBlock((Block)block, false), new RegistryObject[]{ModBlocks.PIXIE_UTREM_JAR});
        this.take(block -> this.pixieUtremJarBlock((Block)block, true), new RegistryObject[]{ModBlocks.CORRUPTED_PIXIE_UTREM_JAR});
        this.take(this::mushroomBlock, new RegistryObject[]{ModBlocks.FUNGYSS_BLOCK});
        this.take(block -> this.logBlock((RotatedPillarBlock)block), new RegistryObject[]{ModBlocks.FUNGYSS_STEM, ModBlocks.CHERRY_LOG, ModBlocks.AURUM_LOG, ModBlocks.STRIPPED_AURUM_LOG, ModBlocks.STRIPPED_CHERRY_LOG});
        this.take(block -> this.axisBlock((RotatedPillarBlock)block, this.modLoc("block/fungyss_stem"), this.modLoc("block/fungyss_stem")), new RegistryObject[]{ModBlocks.FUNGYSS_HYPHAE});
        this.take(block -> {
            String name = this.getName((Block)block).substring(0, this.getName((Block)block).length() - 5);
            this.axisBlock((RotatedPillarBlock)block, this.modLoc("block/" + name + "_log"), this.modLoc("block/" + name + "_log"));
        }, new RegistryObject[]{ModBlocks.CHERRY_WOOD, ModBlocks.AURUM_WOOD, ModBlocks.STRIPPED_CHERRY_WOOD, ModBlocks.STRIPPED_AURUM_WOOD});
        this.take(block -> this.crossCropBlock((CropBlock)block), new RegistryObject[]{ModBlocks.GOLDEN_ORCHID, ModBlocks.STRANGE_ROOT});
        this.take(this::magicalFarmlandBlock, new RegistryObject[]{ModBlocks.MAGICAL_FARMLAND});
        this.take(this::leafCarpetBlock, new RegistryObject[]{ModBlocks.CHERRY_LEAF_CARPET});
        ResourceLocation polishedDarkstone = this.modLoc("block/polished_darkstone");
        this.take(block -> this.pressurePlateBlock((Block)block, polishedDarkstone), new RegistryObject[]{ModBlocks.POLISHED_DARKSTONE_PRESSURE_PLATE});
        this.take(block -> this.buttonBlock((ButtonBlock)block, polishedDarkstone), new RegistryObject[]{ModBlocks.POLISHED_DARKSTONE_BUTTON});
        this.take(this::runicChiseledPolishedDarkstone, new RegistryObject[]{ModBlocks.RUNIC_CHISELED_POLISHED_DARKSTONE});
        this.take(this::pillarBlock, new RegistryObject[]{ModBlocks.ARCANE_POLISHED_DARKSTONE_PILLAR, ModBlocks.ARCANE_POLISHED_DARKSTONE_ROD});
        this.take(this::arcaneCrystalObelisk, new RegistryObject[]{ModBlocks.ARCANE_CRYSTAL_OBELISK});
        this.take(block -> this.simpleBlock((Block)block, (ModelFile)this.models().cross(this.getName((Block)block), this.modLoc("block/" + this.getName((Block)block)))), new RegistryObject[]{ModBlocks.FUNGYSS, ModBlocks.GROWING_EDELWOOD});
        this.take(this::edelwoodLogBlock, new RegistryObject[]{ModBlocks.EDELWOOD_LOG});
        this.take(this::carvedEdelwoodLogBlock, new RegistryObject[]{ModBlocks.CARVED_EDELWOOD_LOG});
        this.take(block -> this.horizontalBlock((Block)block, (ModelFile)this.getExistingModel(this.modLoc("edelwood_branch"))), new RegistryObject[]{ModBlocks.EDELWOOD_BRANCH});
        this.take(block -> this.horizontalBlock((Block)block, (ModelFile)this.models().getExistingFile(this.modLoc("block/edelwood_ladder"))), new RegistryObject[]{ModBlocks.EDELWOOD_LADDER});
        this.take(block -> this.pressurePlateBlock((Block)block, this.modLoc("block/deorum_block")), new RegistryObject[]{ModBlocks.DEORUM_PRESSURE_PLATE});
        this.take(block -> this.signBlock((StandingSignBlock)((RegistryObject)ModBlocks.FUNGYSS_SIGN.getFirst()).get(), (WallSignBlock)((RegistryObject)ModBlocks.FUNGYSS_SIGN.getSecond()).get()), new RegistryObject[]{(RegistryObject)ModBlocks.FUNGYSS_SIGN.getFirst()});
        this.take(block -> this.signBlock((StandingSignBlock)((RegistryObject)ModBlocks.CHERRY_SIGN.getFirst()).get(), (WallSignBlock)((RegistryObject)ModBlocks.CHERRY_SIGN.getSecond()).get()), new RegistryObject[]{(RegistryObject)ModBlocks.CHERRY_SIGN.getFirst()});
        this.take(block -> this.signBlock((StandingSignBlock)((RegistryObject)ModBlocks.AURUM_SIGN.getFirst()).get(), (WallSignBlock)((RegistryObject)ModBlocks.AURUM_SIGN.getSecond()).get()), new RegistryObject[]{(RegistryObject)ModBlocks.AURUM_SIGN.getFirst()});
        this.take(block -> this.signBlock((StandingSignBlock)((RegistryObject)ModBlocks.EDELWOOD_SIGN.getFirst()).get(), (WallSignBlock)((RegistryObject)ModBlocks.EDELWOOD_SIGN.getSecond()).get()), new RegistryObject[]{(RegistryObject)ModBlocks.EDELWOOD_SIGN.getFirst()});
        this.take(this::cherryFlowerVinesBlock, new RegistryObject[]{ModBlocks.CHERRY_FLOWER_VINES});
        this.take(this::cherryFlowerVinesPlantBlock, new RegistryObject[]{ModBlocks.CHERRY_FLOWER_VINES_PLANT});
        this.take(this::lanternBlock, new RegistryObject[]{ModBlocks.DEORUM_LANTERN, ModBlocks.DEORUM_SOUL_LANTERN});
        this.take(block -> this.particleOnly((Block)block, this.modLoc("block/black_hole")), new RegistryObject[]{ModBlocks.BLACK_HOLE});
        this.take(this::empty, new RegistryObject[]{ModBlocks.CLIBANO_MAIN_PART});
        this.take(block -> {
            ResourceLocation front = this.modLoc("block/clibano_combustion/clibano_center_front_off");
            ResourceLocation side = this.modLoc("block/clibano_combustion/clibano_center_side");
            ResourceLocation top = this.modLoc("block/clibano_combustion/clibano_center_top");
            this.horizontalBlock((Block)block, (ModelFile)((BlockModelBuilder)this.models().cube(this.getName((Block)block), side, top, front, side, side, side)).texture("particle", side));
        }, new RegistryObject[]{ModBlocks.CLIBANO_CORE});
        this.take(block -> {
            ModelFile.ExistingModelFile bottom = this.getExistingModel(this.modLoc("clibano_corner_bottom"));
            ModelFile.ExistingModelFile top = this.getExistingModel(this.modLoc("clibano_corner_top"));
            this.horizontalBlock((Block)block, arg_0 -> ModBlockStateProvider.lambda$registerStatesAndModels$24((ModelFile)bottom, (ModelFile)top, arg_0), 90);
        }, new RegistryObject[]{ModBlocks.CLIBANO_CORNER});
        this.take(block -> this.directionalBlock((Block)block, state -> {
            ClibanoCenterType type = (ClibanoCenterType)((Object)((Object)((Object)state.m_61143_(ModBlockStateProperties.CLIBANO_CENTER_TYPE))));
            return switch (type) {
                case ClibanoCenterType.SIDE, ClibanoCenterType.TOP, ClibanoCenterType.FRONT_OFF -> (BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.getName((Block)block) + "_" + type.m_7912_(), this.modLoc("block/clibano_center"))).texture("texture", this.modLoc("block/clibano_combustion/clibano_center_" + type.m_7912_()));
                default -> (BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.getName((Block)block) + "_" + type.m_7912_(), this.modLoc("block/clibano_center"))).texture("texture", this.modLoc("block/clibano_combustion/" + type.m_7912_().substring(6) + "/clibano_center_front"));
            };
        }), new RegistryObject[]{ModBlocks.CLIBANO_CENTER});
        this.take(block -> {
            ResourceLocation off = this.modLoc("block/clibano_combustion/clibano_side_off");
            ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.getName((Block)block) + "_off", this.modLoc("block/clibano_side_horizontal"))).texture("right", off)).texture("left", off);
            ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.getName((Block)block) + "_off_mirrored", this.modLoc("block/clibano_side_horizontal"))).texture("right", off)).texture("left", off);
            for (ClibanoFireType type : ClibanoFireType.values()) {
                ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.getName((Block)block) + "_" + type.m_7912_(), this.modLoc("block/clibano_side_horizontal"))).texture("right", this.modLoc("block/clibano_combustion/" + type.m_7912_() + "/clibano_side"))).texture("left", off);
                ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.getName((Block)block) + "_" + type.m_7912_() + "_mirrored", this.modLoc("block/clibano_side_horizontal"))).texture("right", off)).texture("left", this.modLoc("block/clibano_combustion/" + type.m_7912_() + "/clibano_side"));
            }
            this.horizontalBlock((Block)block, state -> this.getExistingModel(this.modLoc(this.getName((Block)block) + "_" + ((ClibanoSideType)((Object)((Object)((Object)state.m_61143_(ModBlockStateProperties.CLIBANO_SIDE_TYPE))))).m_7912_() + ((Boolean)state.m_61143_((Property)ModBlockStateProperties.MIRRORED) != false ? "_mirrored" : ""))));
        }, new RegistryObject[]{ModBlocks.CLIBANO_SIDE_HORIZONTAL});
        this.take(block -> {
            ResourceLocation off = this.modLoc("block/clibano_combustion/clibano_side_off");
            ((BlockModelBuilder)this.models().withExistingParent(this.getName((Block)block) + "_bottom_off", this.modLoc("block/clibano_side_vertical_bottom"))).texture("side", off);
            ((BlockModelBuilder)this.models().withExistingParent(this.getName((Block)block) + "_top_off", this.modLoc("block/clibano_side_vertical_top"))).texture("side", off);
            for (ClibanoFireType type : ClibanoFireType.values()) {
                ((BlockModelBuilder)this.models().withExistingParent(this.getName((Block)block) + "_bottom_" + type.m_7912_(), this.modLoc("block/clibano_side_vertical_bottom"))).texture("side", this.modLoc("block/clibano_combustion/" + type.m_7912_() + "/clibano_side"));
                ((BlockModelBuilder)this.models().withExistingParent(this.getName((Block)block) + "_top_" + type.m_7912_(), this.modLoc("block/clibano_side_vertical_top"))).texture("side", this.modLoc("block/clibano_combustion/" + type.m_7912_() + "/clibano_side"));
            }
            this.horizontalBlock((Block)block, state -> this.getExistingModel(this.modLoc(this.getName((Block)block) + "_" + ((Boolean)state.m_61143_((Property)BlockStateProperties.f_61427_) != false ? "bottom" : "top") + "_" + ((ClibanoSideType)((Object)((Object)((Object)state.m_61143_(ModBlockStateProperties.CLIBANO_SIDE_TYPE))))).m_7912_())));
        }, new RegistryObject[]{ModBlocks.CLIBANO_SIDE_VERTICAL});
        this.take(block -> this.chainBlock((Block)block, this.modLoc("block/deorum_chain")), new RegistryObject[]{ModBlocks.DEORUM_CHAIN});
        this.take(this::pedestalBlock, new RegistryObject[]{ModBlocks.DARKSTONE_PEDESTAL, ModBlocks.MAGNETIZED_DARKSTONE_PEDESTAL});
        this.forEach(block -> block instanceof FenceBlock, block -> {
            ResourceLocation resourceLocation = this.modLoc("block/" + this.getName((Block)block).substring(0, this.getName((Block)block).length() - 5));
            this.fenceBlock((FenceBlock)block, new ResourceLocation(resourceLocation.m_135827_(), resourceLocation.m_135815_().concat("planks")));
        });
        this.forEach(block -> block instanceof FenceGateBlock, block -> {
            ResourceLocation resourceLocation = this.modLoc("block/" + this.getName((Block)block).substring(0, this.getName((Block)block).length() - 10));
            this.fenceGateBlock((FenceGateBlock)block, new ResourceLocation(resourceLocation.m_135827_(), resourceLocation.m_135815_().concat("planks")));
        });
        this.forEach(block -> block instanceof ButtonBlock, block -> {
            ResourceLocation resourceLocation = this.modLoc("block/" + this.getName((Block)block).substring(0, this.getName((Block)block).length() - 6));
            this.buttonBlock((ButtonBlock)block, new ResourceLocation(resourceLocation.m_135827_(), resourceLocation.m_135815_().concat("planks")));
        });
        this.forEach(block -> block instanceof PressurePlateBlock && block.m_49966_().m_60767_() == Material.f_76320_, block -> {
            ResourceLocation resourceLocation = this.modLoc("block/" + this.getName((Block)block).substring(0, this.getName((Block)block).length() - 14));
            this.pressurePlateBlock((Block)block, new ResourceLocation(resourceLocation.m_135827_(), resourceLocation.m_135815_().concat("planks")));
        });
        this.forEach(block -> block instanceof DoorBlock, block -> this.doorBlock((DoorBlock)block, this.modLoc("block/" + this.getName((Block)block) + "_bottom"), this.modLoc("block/" + this.getName((Block)block) + "_top")));
        this.forEach(block -> block instanceof TrapDoorBlock, block -> this.trapdoorBlock((TrapDoorBlock)block, this.modLoc("block/" + this.getName((Block)block)), true));
        this.forEach(block -> block instanceof SaplingBlock, block -> this.simpleBlock((Block)block, (ModelFile)this.models().cross(this.getName((Block)block), this.modLoc("block/" + this.getName((Block)block)))));
        this.forEach(block -> block instanceof IronBarsBlock, block -> this.paneBlock((IronBarsBlock)block, this.modLoc("block/" + this.getName((Block)block).substring(0, this.getName((Block)block).length() - 5)), this.modLoc("block/" + this.getName((Block)block) + "_top")));
        this.forEach(block -> block instanceof StairBlock, block -> {
            ResourceLocation resourceLocation;
            ResourceLocation resourceLocation2 = resourceLocation = this.getName((Block)block).contains("brick") ? this.modLoc("block/" + this.getName((Block)block).substring(0, this.getName((Block)block).length() - 7).concat("s")) : this.modLoc("block/" + this.getName((Block)block).substring(0, this.getName((Block)block).length() - 7));
            if (block.m_49966_().m_60767_() == Material.f_76320_) {
                resourceLocation = new ResourceLocation(resourceLocation.m_135827_(), resourceLocation.m_135815_().concat("_planks"));
            }
            this.stairsBlock((StairBlock)block, resourceLocation);
        });
        this.forEach(block -> block instanceof WallBlock, block -> {
            ResourceLocation resourceLocation;
            ResourceLocation resourceLocation2 = resourceLocation = this.getName((Block)block).contains("brick") ? this.modLoc("block/" + this.getName((Block)block).substring(0, this.getName((Block)block).length() - 5).concat("s")) : this.modLoc("block/" + this.getName((Block)block).substring(0, this.getName((Block)block).length() - 5));
            if (block.m_49966_().m_60767_() == Material.f_76320_) {
                resourceLocation = new ResourceLocation(resourceLocation.m_135827_(), resourceLocation.m_135815_().concat("_planks"));
            }
            this.wallBlock((WallBlock)block, resourceLocation);
        });
        this.forEach(block -> block instanceof FlowerPotBlock, block -> {
            ResourceLocation name = Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)((FlowerPotBlock)block).m_53560_()));
            this.simpleFlowerPotBlock((Block)block, new ResourceLocation(name.m_135827_(), "block/" + name.m_135815_()));
        });
        ArrayList slabs = new ArrayList();
        this.forEach(block -> block instanceof SlabBlock, slabs::add);
        this.forEach(arg_0 -> ((ModBlockStateProvider)this).simpleBlock(arg_0));
        slabs.forEach(block -> {
            ResourceLocation resourceLocation;
            ResourceLocation resourceLocation2 = resourceLocation = this.getName((Block)block).contains("brick") ? this.modLoc("block/" + this.getName((Block)block).substring(0, this.getName((Block)block).length() - 5).concat("s")) : this.modLoc("block/" + this.getName((Block)block).substring(0, this.getName((Block)block).length() - 5));
            if (block.m_49966_().m_60767_() == Material.f_76320_) {
                resourceLocation = new ResourceLocation(resourceLocation.m_135827_(), resourceLocation.m_135815_().concat("_planks"));
            }
            this.slabBlock((SlabBlock)block, resourceLocation, resourceLocation);
        });
    }

    private void empty(Block block) {
        this.simpleBlock(block, (ModelFile)this.models().getBuilder(this.getName(block)));
    }

    private void particleOnly(Block block, ResourceLocation particle) {
        this.simpleBlock(block, (ModelFile)((BlockModelBuilder)this.models().getBuilder(this.getName(block))).texture("particle", particle));
    }

    private void cubeAllCutout(Block block, ResourceLocation texture, ResourceLocation emissiveTexture) {
        this.simpleBlock(block, (ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.getName(block), this.modLoc("block/cube_all_cutout"))).texture("all", texture)).texture("cutout", emissiveTexture));
    }

    private void cubeAllCutout(Block block, ResourceLocation texture, ResourceLocation emissiveTexture, ResourceLocation particle) {
        this.simpleBlock(block, (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.getName(block), this.modLoc("block/cube_all_cutout"))).texture("particle", particle)).texture("all", texture)).texture("cutout", emissiveTexture));
    }

    private void cubeColumn(Block block, ResourceLocation side, ResourceLocation end) {
        this.simpleBlock(block, (ModelFile)this.models().cubeColumn(this.getName(block), side, end));
    }

    private void randomRotation(Block block) {
        ModelBuilder model = this.models().cubeAll(this.getName(block), this.modLoc("block/" + this.getName(block)));
        ModelBuilder mirroredModel = ((BlockModelBuilder)this.models().withExistingParent(this.getName(block) + "_mirrored", this.mcLoc("block/cube_mirrored_all"))).texture("all", this.modLoc("block/" + this.getName(block)));
        this.getVariantBuilder(block).partialState().addModels(ConfiguredModel.builder().modelFile((ModelFile)model).nextModel().modelFile((ModelFile)mirroredModel).nextModel().modelFile((ModelFile)model).rotationY(180).nextModel().modelFile((ModelFile)mirroredModel).rotationY(180).build());
    }

    private void pixieUtremJarBlock(Block block, boolean corrupted) {
        ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.getName(block), this.modLoc("block/pixie_utrem_jar_template"))).texture("bottle_block_top", this.modLoc("block/" + (corrupted ? "corrupted_" : "") + "utrem_jar_top"))).texture("bottle_block_bottom", this.modLoc("block/" + (corrupted ? "corrupted_" : "") + "utrem_jar_bottom"))).texture("bottle_block_side", this.modLoc("block/" + (corrupted ? "corrupted_" : "") + "utrem_jar_side"))).texture("pixie", this.modLoc("block/" + (corrupted ? "corrupted_" : "") + "utrem_jar_pixie"));
        this.simpleBlock(block, (ModelFile)model);
    }

    private void signBlock(StandingSignBlock signBlock, WallSignBlock wallSignBlock) {
        ModelBuilder sign = this.models().sign(this.getName((Block)signBlock), this.modLoc("block/" + signBlock.m_56297_().m_61846_().split(":")[1] + "_planks"));
        this.simpleBlock((Block)signBlock, (ModelFile)sign);
        this.simpleBlock((Block)wallSignBlock, (ModelFile)sign);
    }

    private void mushroomBlock(Block block) {
        ModelBuilder model = ((BlockModelBuilder)this.models().withExistingParent(this.getName(block), this.mcLoc("block/template_single_face"))).texture("texture", this.modLoc("block/" + this.getName(block)));
        ModelBuilder modelInside = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.getName(block) + "_inside", this.mcLoc("block/template_single_face"))).texture("texture", this.modLoc("block/" + this.getName(block) + "_inside"))).ao(false);
        ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder(block).part().modelFile((ModelFile)model).addModel()).condition((Property)BlockStateProperties.f_61368_, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)model).rotationY(90).uvLock(true).addModel()).condition((Property)BlockStateProperties.f_61369_, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)model).rotationY(180).uvLock(true).addModel()).condition((Property)BlockStateProperties.f_61370_, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)model).rotationY(270).uvLock(true).addModel()).condition((Property)BlockStateProperties.f_61371_, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)model).rotationX(270).uvLock(true).addModel()).condition((Property)BlockStateProperties.f_61366_, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)model).rotationX(90).uvLock(true).addModel()).condition((Property)BlockStateProperties.f_61367_, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)modelInside).addModel()).condition((Property)BlockStateProperties.f_61368_, (Comparable[])new Boolean[]{false}).end().part().modelFile((ModelFile)modelInside).rotationY(90).uvLock(true).addModel()).condition((Property)BlockStateProperties.f_61369_, (Comparable[])new Boolean[]{false}).end().part().modelFile((ModelFile)modelInside).rotationY(180).uvLock(true).addModel()).condition((Property)BlockStateProperties.f_61370_, (Comparable[])new Boolean[]{false}).end().part().modelFile((ModelFile)modelInside).rotationY(270).uvLock(true).addModel()).condition((Property)BlockStateProperties.f_61371_, (Comparable[])new Boolean[]{false}).end().part().modelFile((ModelFile)modelInside).rotationX(270).uvLock(true).addModel()).condition((Property)BlockStateProperties.f_61366_, (Comparable[])new Boolean[]{false}).end().part().modelFile((ModelFile)modelInside).rotationX(90).uvLock(true).addModel()).condition((Property)BlockStateProperties.f_61367_, (Comparable[])new Boolean[]{false}).end();
        this.models().singleTexture(this.getName(block) + "_inventory", this.mcLoc("block/cube_all"), "all", this.modLoc("block/" + this.getName(block)));
    }

    private void runicChiseledPolishedDarkstone(Block block) {
        ((VariantBlockStateBuilder)this.getVariantBuilder(block).partialState().with((Property)ModBlockStateProperties.ACTIVATED, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)this.models().cubeColumn(this.getName(block), this.modLoc("block/runic_chiseled_polished_darkstone"), this.modLoc("block/chiseled_polished_darkstone"))).addModel()).partialState().with((Property)ModBlockStateProperties.ACTIVATED, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.getName(block) + "_activated", this.modLoc("block/cube_column_side_layer"))).texture("end", this.modLoc("block/chiseled_polished_darkstone"))).texture("side", this.modLoc("block/runic_chiseled_polished_darkstone_activated"))).texture("layer", this.modLoc("block/runic_chiseled_polished_darkstone_layer"))).addModel();
    }

    private void pillarBlock(Block block) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> {
            PillarType type = (PillarType)((Object)((Object)state.m_61143_(ModBlockStateProperties.PILLAR_TYPE)));
            Direction.Axis axis = (Direction.Axis)state.m_61143_((Property)RotatedPillarBlock.f_55923_);
            return ConfiguredModel.builder().modelFile((ModelFile)this.getExistingModel(this.modLoc(this.getName(block) + (String)(type == PillarType.SINGLE ? "" : "_" + type.m_7912_())))).rotationX(axis != Direction.Axis.Y ? 90 : 0).rotationY(axis == Direction.Axis.X ? 90 : (axis == Direction.Axis.Z ? 180 : 0)).build();
        }, new Property[]{BlockStateProperties.f_61362_});
    }

    private void arcaneCrystalObelisk(Block block) {
        ResourceLocation topTexture = this.modLoc("block/" + this.getName(block) + "_top");
        this.getVariantBuilder(block).forAllStatesExcept(state -> {
            String part = ((ObeliskPart)((Object)((Object)state.m_61143_(ArcaneCrystalObeliskBlock.PART)))).m_7912_();
            BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.getName(block) + "_" + part, this.modLoc("obelisk_" + part))).texture("0", topTexture);
            return ConfiguredModel.builder().modelFile((ModelFile)model.texture(part, this.modLoc("block/" + this.getName(block) + "_" + part))).build();
        }, new Property[]{BlockStateProperties.f_61362_, ModBlockStateProperties.RITUAL});
    }

    private void chainBlock(Block block, ResourceLocation resourceLocation) {
        ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.getName(block), this.mcLoc("block/chain"))).texture("particle", resourceLocation)).texture("all", resourceLocation);
        this.getVariantBuilder(block).forAllStatesExcept(arg_0 -> ModBlockStateProvider.lambda$chainBlock$59((ModelFile)model, arg_0), new Property[]{BlockStateProperties.f_61362_});
    }

    private void edelwoodLogBlock(Block block) {
        ModelFile model = this.getEdelwoodLogModel(this.getName(block));
        ModelFile modelOily = this.getEdelwoodLogModel(this.getName(block) + "_oily");
        this.getVariantBuilder(block).forAllStatesExcept(state -> ConfiguredModel.builder().modelFile((Boolean)state.m_61143_((Property)ModBlockStateProperties.OILY) != false ? modelOily : model).rotationX(state.m_61143_((Property)BlockStateProperties.f_61365_) != Direction.Axis.Y ? 90 : 0).rotationY(state.m_61143_((Property)BlockStateProperties.f_61365_) == Direction.Axis.X ? 90 : 0).build(), new Property[]{BlockStateProperties.f_61362_});
    }

    private ModelFile getEdelwoodLogModel(String name) {
        return ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, this.modLoc("block/hollow_log"))).texture("log", this.modLoc("block/" + name))).texture("top", this.modLoc("block/edelwood_log_top"))).texture("inner", this.modLoc("block/stripped_edelwood_log"));
    }

    private void carvedEdelwoodLogBlock(Block block) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> ConfiguredModel.builder().modelFile((ModelFile)this.models().getExistingFile(this.modLoc("block/" + this.getName(block) + ((Boolean)state.m_61143_((Property)ModBlockStateProperties.LEAVES) != false ? "_leaves" : "") + ((Boolean)state.m_61143_((Property)ModBlockStateProperties.OILY) != false ? "_oily" : "")))).rotationY(((int)((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122435_() + 180) % 360).build(), new Property[]{BlockStateProperties.f_61362_});
    }

    private void crossCropBlock(CropBlock block) {
        IntegerProperty age = block.m_7959_();
        this.getVariantBuilder((Block)block).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)this.models().cross(this.getName((Block)block) + "_stage" + state.m_61143_((Property)age), this.modLoc("block/" + this.getName((Block)block) + "_stage" + state.m_61143_((Property)age)))).build());
    }

    private void magicalFarmlandBlock(Block block) {
        ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.getName(block), this.mcLoc("block/template_farmland"))).texture("dirt", this.modLoc("block/magical_dirt"))).texture("top", this.modLoc("block/magical_farmland"));
        ModelBuilder modelMoist = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.getName(block) + "_moist", this.mcLoc("block/template_farmland"))).texture("dirt", this.modLoc("block/magical_dirt"))).texture("top", this.modLoc("block/magical_farmland_moist"));
        this.getVariantBuilder(block).forAllStates(arg_0 -> ModBlockStateProvider.lambda$magicalFarmlandBlock$63((ModelFile)modelMoist, (ModelFile)model, arg_0));
    }

    private void leafCarpetBlock(Block block) {
        String name = this.getName(block);
        ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(name)).parent((ModelFile)new ModelFile.UncheckedModelFile("builtin/generated"))).texture("layer0", this.modLoc("block/" + name));
        this.getVariantBuilder(block).partialState().modelForState().modelFile((ModelFile)model).rotationX(90).nextModel().modelFile((ModelFile)model).rotationX(90).rotationY(90).nextModel().modelFile((ModelFile)model).rotationX(90).rotationY(180).nextModel().modelFile((ModelFile)model).rotationX(90).rotationY(270).addModel();
        ((BlockModelBuilder)this.models().withExistingParent(name + "_inventory", this.mcLoc("block/pressure_plate_up"))).texture("texture", this.modLoc("block/" + name));
    }

    private void cherryFlowerVinesBlock(Block block) {
        String name = this.getName(block);
        ModelBuilder model = this.models().cross(name, this.modLoc("block/" + name));
        this.getVariantBuilder(block).partialState().modelForState().modelFile((ModelFile)model).addModel();
    }

    private void cherryFlowerVinesPlantBlock(Block block) {
        String name = this.getName(block);
        ModelBuilder model0 = this.models().cross(name + "0", this.modLoc("block/" + name + "0"));
        ModelBuilder model1 = this.models().cross(name + "1", this.modLoc("block/" + name + "1"));
        this.getVariantBuilder(block).partialState().modelForState().modelFile((ModelFile)model0).nextModel().modelFile((ModelFile)model1).addModel();
    }

    public void doorBlock(DoorBlock block, ResourceLocation bottom, ResourceLocation top) {
        this.doorBlockInternal(block, ForgeRegistries.BLOCKS.getKey((Object)block).toString(), bottom, top);
    }

    private void doorBlockInternal(DoorBlock block, String baseName, ResourceLocation bottom, ResourceLocation top) {
        BlockModelBuilder bottomLeft = this.doorBottomLeft(baseName + "_bottom_left", bottom, top);
        BlockModelBuilder bottomLeftOpen = this.doorBottomLeftOpen(baseName + "_bottom_left_open", bottom, top);
        BlockModelBuilder bottomRight = this.doorBottomRight(baseName + "_bottom_right", bottom, top);
        BlockModelBuilder bottomRightOpen = this.doorBottomRightOpen(baseName + "_bottom_right_open", bottom, top);
        BlockModelBuilder topLeft = this.doorTopLeft(baseName + "_top_left", bottom, top);
        BlockModelBuilder topLeftOpen = this.doorTopLeftOpen(baseName + "_top_left_open", bottom, top);
        BlockModelBuilder topRight = this.doorTopRight(baseName + "_top_right", bottom, top);
        BlockModelBuilder topRightOpen = this.doorTopRightOpen(baseName + "_top_right_open", bottom, top);
        this.doorBlock(block, (ModelFile)bottomLeft, (ModelFile)bottomLeftOpen, (ModelFile)bottomRight, (ModelFile)bottomRightOpen, (ModelFile)topLeft, (ModelFile)topLeftOpen, (ModelFile)topRight, (ModelFile)topRightOpen);
    }

    public void doorBlock(DoorBlock block, ModelFile bottomLeft, ModelFile bottomLeftOpen, ModelFile bottomRight, ModelFile bottomRightOpen, ModelFile topLeft, ModelFile topLeftOpen, ModelFile topRight, ModelFile topRightOpen) {
        this.getVariantBuilder((Block)block).forAllStatesExcept(state -> {
            int yRot = (int)((Direction)state.m_61143_((Property)DoorBlock.f_52726_)).m_122435_() + 90;
            boolean right = state.m_61143_((Property)DoorBlock.f_52728_) == DoorHingeSide.RIGHT;
            boolean open = (Boolean)state.m_61143_((Property)DoorBlock.f_52727_);
            if (open) {
                yRot += 90;
            }
            if (right && open) {
                yRot += 180;
            }
            return ConfiguredModel.builder().modelFile(state.m_61143_((Property)DoorBlock.f_52730_) == DoubleBlockHalf.LOWER ? (right ? (open ? bottomRightOpen : bottomRight) : (open ? bottomLeftOpen : bottomLeft)) : (right ? (open ? topRightOpen : topRight) : (open ? topLeftOpen : topLeft))).rotationY(yRot %= 360).build();
        }, new Property[]{DoorBlock.f_52729_});
    }

    public BlockModelBuilder doorBottomLeft(String name, ResourceLocation bottom, ResourceLocation top) {
        return this.door(name, "door_bottom_left", bottom, top);
    }

    public BlockModelBuilder doorBottomLeftOpen(String name, ResourceLocation bottom, ResourceLocation top) {
        return this.door(name, "door_bottom_left_open", bottom, top);
    }

    public BlockModelBuilder doorBottomRight(String name, ResourceLocation bottom, ResourceLocation top) {
        return this.door(name, "door_bottom_right", bottom, top);
    }

    public BlockModelBuilder doorBottomRightOpen(String name, ResourceLocation bottom, ResourceLocation top) {
        return this.door(name, "door_bottom_right_open", bottom, top);
    }

    public BlockModelBuilder doorTopLeft(String name, ResourceLocation bottom, ResourceLocation top) {
        return this.door(name, "door_top_left", bottom, top);
    }

    public BlockModelBuilder doorTopLeftOpen(String name, ResourceLocation bottom, ResourceLocation top) {
        return this.door(name, "door_top_left_open", bottom, top);
    }

    public BlockModelBuilder doorTopRight(String name, ResourceLocation bottom, ResourceLocation top) {
        return this.door(name, "door_top_right", bottom, top);
    }

    public BlockModelBuilder doorTopRightOpen(String name, ResourceLocation bottom, ResourceLocation top) {
        return this.door(name, "door_top_right_open", bottom, top);
    }

    private BlockModelBuilder door(String name, String model, ResourceLocation bottom, ResourceLocation top) {
        return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, "block/" + model)).texture("bottom", bottom)).texture("top", top);
    }

    private void lanternBlock(Block block) {
        ModelBuilder model = ((BlockModelBuilder)this.models().withExistingParent(this.getName(block), this.mcLoc("template_lantern"))).texture("lantern", this.modLoc("block/" + this.getName(block)));
        ModelBuilder hangingModel = ((BlockModelBuilder)this.models().withExistingParent(this.getName(block) + "_hanging", this.mcLoc("template_hanging_lantern"))).texture("lantern", this.modLoc("block/" + this.getName(block)));
        ((VariantBlockStateBuilder)this.getVariantBuilder(block).partialState().with((Property)BlockStateProperties.f_61435_, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)model).addModel()).partialState().with((Property)BlockStateProperties.f_61435_, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)hangingModel).addModel();
    }

    private void pedestalBlock(Block block) {
        String name = this.getName(block);
        ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, this.modLoc("template_pedestal"))).texture("top", this.modLoc("block/" + name + "_top"))).texture("side", this.modLoc("block/" + name));
        this.getVariantBuilder(block).partialState().modelForState().modelFile((ModelFile)model).addModel();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$magicalFarmlandBlock$63(ModelFile modelMoist, ModelFile model, BlockState state) {
        return ConfiguredModel.builder().modelFile((Integer)state.m_61143_((Property)FarmBlock.f_53243_) == 7 ? modelMoist : model).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$chainBlock$59(ModelFile model, BlockState state) {
        return ConfiguredModel.builder().modelFile(model).rotationX(state.m_61143_((Property)BlockStateProperties.f_61365_) != Direction.Axis.Y ? 90 : 0).rotationY(state.m_61143_((Property)BlockStateProperties.f_61365_) == Direction.Axis.X ? 90 : 0).build();
    }

    private static /* synthetic */ ModelFile lambda$registerStatesAndModels$24(ModelFile bottom, ModelFile top, BlockState state) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61427_) != false ? bottom : top;
    }
}

