/*
 * Decompiled with CFR 0.152.
 */
package io.github.elytra.movingworld.common.network;

import io.github.elytra.movingworld.MovingWorldMod;
import io.github.elytra.movingworld.common.chunk.ChunkIO;
import io.github.elytra.movingworld.common.chunk.mobilechunk.MobileChunkClient;
import io.github.elytra.movingworld.common.entity.EntityMovingWorld;
import io.github.elytra.movingworld.common.network.MovingWorldClientAction;
import io.github.elytra.movingworld.common.tile.TileMovingMarkingBlock;
import io.github.elytra.movingworld.repackage.com.unascribed.lambdanetwork.DataType;
import io.github.elytra.movingworld.repackage.com.unascribed.lambdanetwork.LambdaNetwork;
import io.github.elytra.movingworld.repackage.com.unascribed.lambdanetwork.LambdaNetworkBuilder;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.relauncher.Side;

public class MovingWorldNetworking {
    public static LambdaNetwork NETWORK;

    public static void setupNetwork() {
        MovingWorldMod.LOG.info("Setting up network...");
        NETWORK = MovingWorldNetworking.registerPackets(LambdaNetwork.builder().channel("MovingWorld")).build();
        MovingWorldMod.LOG.info("Setup network! " + NETWORK.toString());
    }

    private static LambdaNetworkBuilder registerPackets(LambdaNetworkBuilder builder) {
        builder = builder.packet("FarInteractMessage").boundTo(Side.SERVER).with(DataType.INT, "dimID").with(DataType.INT, "entityID").with(DataType.INT, "hand").with(DataType.NBT_COMPOUND, "stack").handledBy((entityPlayer, token) -> {
            Entity unCast;
            WorldServer world = DimensionManager.getWorld((int)token.getInt("dimID"));
            if (world != null && (unCast = world.func_73045_a(token.getInt("entityID"))) != null && unCast instanceof EntityMovingWorld) {
                EntityMovingWorld movingWorld = (EntityMovingWorld)unCast;
                EnumHand hand = EnumHand.values()[token.getInt("hand")];
                ItemStack stack = null;
                if (token.getNBT("stack") != null) {
                    stack = ItemStack.func_77949_a((NBTTagCompound)token.getNBT("stack"));
                }
                entityPlayer.func_184822_a((Entity)movingWorld, stack, hand);
            }
        });
        builder = builder.packet("ChunkBlockUpdateMessage").boundTo(Side.CLIENT).with(DataType.INT, "dimID").with(DataType.INT, "entityID").with(DataType.ARBITRARY, "chunk").handledOnMainThreadBy((entityPlayer, token) -> {
            Entity unCast;
            ByteBuf buf = Unpooled.wrappedBuffer((byte[])token.getData("chunk"));
            WorldServer world = DimensionManager.getWorld((int)token.getInt("dimID"));
            if (world != null && (unCast = world.func_73045_a(token.getInt("entityID"))) != null && unCast instanceof EntityMovingWorld) {
                EntityMovingWorld movingWorld = (EntityMovingWorld)unCast;
                try {
                    ChunkIO.readCompressed(buf, movingWorld.getMobileChunk());
                }
                catch (IOException e) {
                    MovingWorldMod.LOG.error((Object)e);
                }
            }
        });
        builder = builder.packet("TileEntitiesMessage").boundTo(Side.CLIENT).with(DataType.INT, "dimID").with(DataType.INT, "entityID").with(DataType.NBT_COMPOUND, "tagCompound").handledOnMainThreadBy((entityPlayer, token) -> {
            EntityMovingWorld movingWorld;
            Entity unCast;
            NBTTagCompound tagCompound = token.getNBT("tagCompound");
            WorldServer world = DimensionManager.getWorld((int)token.getInt("dimID"));
            if (world != null && (unCast = world.func_73045_a(token.getInt("entityID"))) != null && unCast instanceof EntityMovingWorld && (movingWorld = (EntityMovingWorld)unCast) != null && tagCompound != null && movingWorld.getMobileChunk() != null && movingWorld.getMobileChunk() instanceof MobileChunkClient) {
                NBTTagList list = tagCompound.func_150295_c("list", 10);
                for (int i = 0; i < list.func_74745_c(); ++i) {
                    NBTTagCompound nbt = list.func_150305_b(i);
                    if (nbt == null) continue;
                    int x = nbt.func_74762_e("x");
                    int y = nbt.func_74762_e("y");
                    int z = nbt.func_74762_e("z");
                    BlockPos pos = new BlockPos(x, y, z);
                    try {
                        TileEntity te = movingWorld.getMobileChunk().func_175625_s(pos);
                        if (te == null) continue;
                        te.func_145839_a(nbt);
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                ((MobileChunkClient)movingWorld.getMobileChunk()).getRenderer().markDirty();
            }
        });
        builder = builder.packet("RequestMovingWorldDataMessage").boundTo(Side.SERVER).with(DataType.INT, "dimID").with(DataType.INT, "entityID").handledOnMainThreadBy((entityPlayer, token) -> {
            Entity unCast;
            WorldServer world = DimensionManager.getWorld((int)token.getInt("dimID"));
            if (world != null && (unCast = world.func_73045_a(token.getInt("entityID"))) != null && unCast instanceof EntityMovingWorld) {
                EntityMovingWorld movingWorld = (EntityMovingWorld)unCast;
                NBTTagCompound tagCompound = new NBTTagCompound();
                NBTTagList list = new NBTTagList();
                for (TileEntity te : movingWorld.getMobileChunk().chunkTileEntityMap.values()) {
                    NBTTagCompound nbt = new NBTTagCompound();
                    if (te instanceof TileMovingMarkingBlock) {
                        ((TileMovingMarkingBlock)te).writeNBTForSending(nbt);
                    } else {
                        te.func_189515_b(nbt);
                    }
                    list.func_74742_a((NBTBase)nbt);
                }
                tagCompound.func_74782_a("list", (NBTBase)list);
                NETWORK.send().packet("TileEntitiesMessage").with("dimID", token.getInt("dimID")).with("entityID", token.getInt("entityID")).with("tagCompound", tagCompound).to((EntityPlayer)entityPlayer);
            }
        });
        builder = builder.packet("MovingWorldClientActionMessage").boundTo(Side.SERVER).with(DataType.INT, "dimID").with(DataType.INT, "entityID").with(DataType.BYTE, "action").handledOnMainThreadBy((entityPlayer, token) -> {
            EntityMovingWorld movingWorld;
            Entity unCast;
            MovingWorldClientAction action = MovingWorldClientAction.fromByte((byte)token.getInt("action"));
            WorldServer world = DimensionManager.getWorld((int)token.getInt("dimID"));
            if (world != null && (unCast = world.func_73045_a(token.getInt("entityID"))) != null && unCast instanceof EntityMovingWorld && (movingWorld = (EntityMovingWorld)unCast) != null && movingWorld.func_184179_bs().func_145782_y() == entityPlayer.func_145782_y()) {
                switch (action) {
                    case DISASSEMBLE: {
                        movingWorld.alignToGrid(true);
                        movingWorld.updatePassengerPosition((Entity)entityPlayer, movingWorld.riderDestination, 1);
                        movingWorld.func_184226_ay();
                        movingWorld.disassemble(false);
                        break;
                    }
                    case DISASSEMBLEWITHOVERWRITE: {
                        movingWorld.alignToGrid(true);
                        movingWorld.updatePassengerPosition((Entity)entityPlayer, movingWorld.riderDestination, 1);
                        movingWorld.func_184226_ay();
                        movingWorld.disassemble(true);
                        break;
                    }
                    case ALIGN: {
                        movingWorld.alignToGrid(true);
                        break;
                    }
                }
            }
        });
        return builder;
    }
}

