/*
 * Decompiled with CFR 0.152.
 */
package io.github.elytra.movingworld.common.config.priority;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.github.elytra.movingworld.MovingWorldMod;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Configuration;
import org.apache.commons.lang3.ArrayUtils;

public class AssemblePriorityConfig {
    public static String CONFIG_VERSION = "MovingWorldCFG.1.0.0";
    public String detectedVersion;
    private Configuration config;
    private Set<String> highPriorityAssembly;
    private Set<String> lowPriorityAssembly;
    private Set<String> highPriorityDisassembly;
    private Set<String> lowPriorityDisassembly;
    private boolean rediscoverPoweredBlocks;
    private Block[] defaultHighPriorityAssemblyBlocks = new Block[]{Blocks.field_150427_aO, Blocks.field_180384_M, Blocks.field_150332_K, Blocks.field_150320_F, Blocks.field_150331_J, Blocks.field_150427_aO};
    private Block[] defaultLowPriorityAssemblyBlocks = new Block[]{Blocks.field_150488_af, Blocks.field_150343_Z};
    private Block[] defaultHighPriorityDisassemblyBlocks = new Block[]{Blocks.field_150332_K, Blocks.field_180384_M};
    private Block[] defaultLowPriorityDisassemblyBlocks = new Block[]{Blocks.field_150384_bq, Blocks.field_150427_aO, Blocks.field_150488_af};
    private Set<String> highPriorityAssemblyBlocksToRegister;
    private Set<String> lowPriorityAssemblyBlocksToRegister;
    private Set<String> highPriorityDisassemblyBlocksToRegister;
    private Set<String> lowPriorityDisassemblyBlocksToRegister;

    public AssemblePriorityConfig(Configuration configuration) {
        this.config = configuration;
        this.highPriorityAssembly = new HashSet<String>();
        this.lowPriorityAssembly = new HashSet<String>();
        this.highPriorityDisassembly = new HashSet<String>();
        this.lowPriorityDisassembly = new HashSet<String>();
        this.highPriorityAssemblyBlocksToRegister = new HashSet<String>();
        this.lowPriorityAssemblyBlocksToRegister = new HashSet<String>();
        this.highPriorityDisassemblyBlocksToRegister = new HashSet<String>();
        this.lowPriorityDisassemblyBlocksToRegister = new HashSet<String>();
    }

    public void loadAndSavePreInit() {
        this.config.load();
        String[] highPriorityAssemblyBlocks = this.config.get("mobile_chunk", "highpriorityassembly_blocks", this.blockArrayToBlockNameArray(this.defaultHighPriorityAssemblyBlocks), "A list of blocks that should be set to air first.").getStringList();
        String[] lowPriorityAssemblyBlocks = this.config.get("mobile_chunk", "lowpriorityassembly_blocks", this.blockArrayToBlockNameArray(this.defaultLowPriorityAssemblyBlocks), "A list of blocks that should be set to air last.").getStringList();
        String[] highPriorityDisassemblyBlocks = this.config.get("mobile_chunk", "highprioritydisassembly_blocks", this.blockArrayToBlockNameArray(this.defaultHighPriorityDisassemblyBlocks), "A list of blocks that should be set to the world first.").getStringList();
        String[] lowPriorityDisassemblyBlocks = this.config.get("mobile_chunk", "lowprioritydisassembly_blocks", this.blockArrayToBlockNameArray(this.defaultLowPriorityDisassemblyBlocks), "A list of blocks that should be set to the world last.").getStringList();
        Collections.addAll(this.highPriorityAssembly, highPriorityAssemblyBlocks);
        Collections.addAll(this.lowPriorityAssembly, lowPriorityAssemblyBlocks);
        Collections.addAll(this.highPriorityDisassembly, highPriorityDisassemblyBlocks);
        Collections.addAll(this.lowPriorityDisassembly, lowPriorityDisassemblyBlocks);
        this.detectedVersion = this.config.get("DONT TOUCH", "CONFIG VERSION", CONFIG_VERSION).getString();
        this.rediscoverPoweredBlocks = this.config.get("general", "Rediscover powered blocks on next restart?", true).getBoolean();
        if (this.detectedVersion != CONFIG_VERSION) {
            this.config.get("DONT TOUCH", "CONFIG VERSION", CONFIG_VERSION).set(CONFIG_VERSION);
            this.rediscoverPoweredBlocks = true;
        }
        this.config.save();
    }

    public void loadAndSaveInit() {
        this.config.load();
        this.discoverPoweredBlocks();
        this.config.save();
    }

    public String[] blockArrayToBlockNameArray(Block[] blocks) {
        String[] retVal = new String[blocks.length];
        for (int i = 0; i < blocks.length; ++i) {
            retVal[i] = ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)blocks[i])).toString();
        }
        return retVal;
    }

    public void loadAndSavePostInit() {
        String[] lowPriorityAssemblyNames;
        String[] highPriorityAssemblyNames;
        this.config.load();
        if (!this.highPriorityAssemblyBlocksToRegister.isEmpty()) {
            this.highPriorityAssembly.addAll(this.highPriorityAssemblyBlocksToRegister);
            highPriorityAssemblyNames = new String[this.highPriorityAssembly.size()];
            highPriorityAssemblyNames = this.highPriorityAssembly.toArray(highPriorityAssemblyNames);
            this.config.get("mobile_chunk", "highpriorityassembly_blocks", this.blockArrayToBlockNameArray(this.defaultHighPriorityAssemblyBlocks), "A list of blocks that should be set to air first.").set(highPriorityAssemblyNames);
        }
        if (!this.lowPriorityAssemblyBlocksToRegister.isEmpty()) {
            this.lowPriorityAssembly.addAll(this.lowPriorityAssemblyBlocksToRegister);
            lowPriorityAssemblyNames = new String[this.lowPriorityAssembly.size()];
            lowPriorityAssemblyNames = this.lowPriorityAssembly.toArray(lowPriorityAssemblyNames);
            this.config.get("mobile_chunk", "lowpriorityassembly_blocks", this.blockArrayToBlockNameArray(this.defaultLowPriorityAssemblyBlocks), "A list of blocks that should be set to air last.").set(lowPriorityAssemblyNames);
        }
        if (!this.highPriorityDisassemblyBlocksToRegister.isEmpty()) {
            this.highPriorityDisassembly.addAll(this.highPriorityDisassemblyBlocksToRegister);
            highPriorityAssemblyNames = new String[this.highPriorityAssembly.size()];
            highPriorityAssemblyNames = this.highPriorityAssembly.toArray(highPriorityAssemblyNames);
            this.config.get("mobile_chunk", "highprioritydisassembly_blocks", this.blockArrayToBlockNameArray(this.defaultHighPriorityDisassemblyBlocks), "A list of blocks that should be set to the world first.").set(highPriorityAssemblyNames);
        }
        if (!this.lowPriorityAssemblyBlocksToRegister.isEmpty()) {
            this.lowPriorityAssembly.addAll(this.lowPriorityAssemblyBlocksToRegister);
            lowPriorityAssemblyNames = new String[this.lowPriorityAssembly.size()];
            lowPriorityAssemblyNames = this.lowPriorityAssembly.toArray(lowPriorityAssemblyNames);
            this.config.get("mobile_chunk", "lowprioritydisassembly_blocks", this.blockArrayToBlockNameArray(this.defaultLowPriorityDisassemblyBlocks), "A list of blocks that should be set to the world last.").set(lowPriorityAssemblyNames);
        }
        this.config.save();
    }

    void discoverPoweredBlocks() {
        if (this.rediscoverPoweredBlocks) {
            ArrayList<String> poweredBlockNames = new ArrayList<String>();
            ArrayList allBlocks = Lists.newArrayList((Iterator)Block.field_149771_c.iterator());
            for (Block checkBlock : allBlocks) {
                IBlockState state = checkBlock.func_176223_P();
                for (IProperty prop : state.func_177228_b().keySet()) {
                    if (!prop.func_177701_a().equals("powered")) continue;
                    String poweredBlockName = ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)checkBlock)).toString();
                    poweredBlockNames.add(poweredBlockName);
                    MovingWorldMod.LOG.info("Found powered block with name: " + poweredBlockName);
                }
            }
            Object[] discoveredPoweredBlockNames = new String[poweredBlockNames.size()];
            for (int i = 0; i < poweredBlockNames.size(); ++i) {
                discoveredPoweredBlockNames[i] = (String)poweredBlockNames.get(i);
            }
            Object[] defaultHighPriorityAssemblyBlockNames = new String[this.defaultHighPriorityAssemblyBlocks.length];
            for (int i = 0; i < this.defaultHighPriorityAssemblyBlocks.length; ++i) {
                defaultHighPriorityAssemblyBlockNames[i] = ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)this.defaultHighPriorityAssemblyBlocks[i])).toString();
            }
            this.config.get("mobile_chunk", "highpriorityassembly_blocks", (String[])defaultHighPriorityAssemblyBlockNames, "A list of blocks that should be set to air first, and then placed last when disassembled.").set((String[])ArrayUtils.addAll((Object[])defaultHighPriorityAssemblyBlockNames, (Object[])discoveredPoweredBlockNames));
            this.config.get("general", "Rediscover powered blocks on next restart?", true).set(false);
            this.highPriorityAssembly = Sets.newHashSet((Object[])ArrayUtils.addAll((Object[])defaultHighPriorityAssemblyBlockNames, (Object[])discoveredPoweredBlockNames));
        }
    }

    public void registerHighPriorityAssemblyBlock(Block block) {
        this.highPriorityAssemblyBlocksToRegister.add(((ResourceLocation)Block.field_149771_c.func_177774_c((Object)block)).toString());
    }

    public void registerLowPriorityAssemblyBlock(Block block) {
        this.lowPriorityAssemblyBlocksToRegister.add(((ResourceLocation)Block.field_149771_c.func_177774_c((Object)block)).toString());
    }

    public void registerHighPriorityDisassemblyBlock(Block block) {
        this.highPriorityDisassemblyBlocksToRegister.add(((ResourceLocation)Block.field_149771_c.func_177774_c((Object)block)).toString());
    }

    public void registerLowPriorityDisassemblyBlock(Block block) {
        this.lowPriorityDisassemblyBlocksToRegister.add(((ResourceLocation)Block.field_149771_c.func_177774_c((Object)block)).toString());
    }

    public Set<String> getHighPriorityAssembly() {
        return this.highPriorityAssembly;
    }

    public Set<String> getLowPriorityAssembly() {
        return this.lowPriorityAssembly;
    }

    public Set<String> getHighPriorityDisassembly() {
        return this.highPriorityDisassembly;
    }

    public Set<String> getLowPriorityDisassembly() {
        return this.lowPriorityDisassembly;
    }
}

