/*
 * Decompiled with CFR 0.152.
 */
package io.github.elytra.movingworld.common.tile;

import io.github.elytra.movingworld.api.IMovingTile;
import io.github.elytra.movingworld.common.chunk.LocatedBlock;
import io.github.elytra.movingworld.common.chunk.MovingWorldAssemblyInteractor;
import io.github.elytra.movingworld.common.chunk.assembly.AssembleResult;
import io.github.elytra.movingworld.common.chunk.assembly.ChunkAssembler;
import io.github.elytra.movingworld.common.entity.EntityMovingWorld;
import io.github.elytra.movingworld.common.entity.MovingWorldInfo;
import io.github.elytra.movingworld.common.util.LocatedBlockList;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;

public abstract class TileMovingMarkingBlock
extends TileEntity
implements IMovingTile {
    public LocatedBlockList removedFluidBlocks;
    private AssembleResult assembleResult;
    private AssembleResult prevResult;

    public TileMovingMarkingBlock() {
        this.setParentMovingWorld(null);
        this.prevResult = null;
        this.assembleResult = null;
    }

    public abstract MovingWorldAssemblyInteractor getInteractor();

    public abstract void setInteractor(MovingWorldAssemblyInteractor var1);

    public abstract MovingWorldInfo getInfo();

    public abstract void setInfo(MovingWorldInfo var1);

    public abstract int getMaxBlocks();

    public AssembleResult getPrevAssembleResult() {
        return this.prevResult;
    }

    public void setPrevAssembleResult(AssembleResult result) {
        this.prevResult = result;
    }

    public AssembleResult getAssembleResult() {
        return this.assembleResult;
    }

    public void setAssembleResult(AssembleResult assembleResult) {
        this.assembleResult = assembleResult;
    }

    public abstract EntityMovingWorld getMovingWorld(World var1);

    public boolean assembleMovingWorld(EntityPlayer player) {
        boolean returnVal = false;
        if (!this.field_145850_b.field_72995_K) {
            this.prevResult = this.assembleResult;
            ChunkAssembler assembler = new ChunkAssembler(this.field_145850_b, this.field_174879_c, this.getMaxBlocks());
            MovingWorldAssemblyInteractor interactor = this.getNewAssemblyInteractor();
            this.assembleResult = assembler.doAssemble(interactor);
            this.assembledMovingWorld(player, returnVal);
            this.setInteractor(interactor);
            switch (this.assembleResult.getType()) {
                case RESULT_OK: {
                    TextComponentString c = new TextComponentString("Assembled " + this.getInfo().getName() + "!");
                    player.func_145747_a((ITextComponent)c);
                    break;
                }
                case RESULT_OK_WITH_WARNINGS: {
                    returnVal = true;
                }
                case RESULT_BLOCK_OVERFLOW: {
                    TextComponentString c = new TextComponentString("Cannot create moving world with more than " + this.getMaxBlocks() + " blocks");
                    player.func_145747_a((ITextComponent)c);
                    break;
                }
                case RESULT_MISSING_MARKER: {
                    TextComponentString c = new TextComponentString("Cannot create moving world with no moving world marker");
                    player.func_145747_a((ITextComponent)c);
                    break;
                }
                case RESULT_ERROR_OCCURED: {
                    TextComponentString c = new TextComponentString("An error occured while assembling moving world. See console log for details.");
                    player.func_145747_a((ITextComponent)c);
                    break;
                }
                case RESULT_NONE: {
                    TextComponentString c = new TextComponentString("Nothing was assembled");
                    player.func_145747_a((ITextComponent)c);
                    break;
                }
            }
        }
        return returnVal;
    }

    public void assembledMovingWorld(EntityPlayer player, boolean returnVal) {
    }

    public boolean mountMovingWorld(EntityPlayer player, EntityMovingWorld movingWorld) {
        if (!this.field_145850_b.field_72995_K && this.assembleResult != null && this.assembleResult.isOK()) {
            this.assembleResult.checkConsistent(this.field_145850_b);
            this.mountedMovingWorld(player, movingWorld, MountStage.PREMSG);
            if (this.assembleResult.getType() == AssembleResult.ResultType.RESULT_INCONSISTENT) {
                return false;
            }
            if (this.assembleResult.getType() == AssembleResult.ResultType.RESULT_OK_WITH_WARNINGS) {
                TextComponentString c = new TextComponentString("Moving world contains changes");
                player.func_145747_a((ITextComponent)c);
            }
            this.mountedMovingWorld(player, movingWorld, MountStage.PRERIDE);
            EntityMovingWorld entity = this.assembleResult.getEntity(this.field_145850_b, movingWorld);
            if (entity != null) {
                entity.setInfo(this.getInfo());
                if (this.field_145850_b.func_72838_d((Entity)entity)) {
                    player.func_184220_m((Entity)entity);
                    this.assembleResult = null;
                    return true;
                }
            }
            this.mountedMovingWorld(player, entity, MountStage.POSTRIDE);
        }
        return false;
    }

    public void undoCompilation(EntityPlayer player) {
        this.assembleResult = this.prevResult;
        this.prevResult = null;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound compound = new NBTTagCompound();
        this.writeNBTForSending(compound);
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, compound);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public abstract MovingWorldAssemblyInteractor getNewAssemblyInteractor();

    public void mountedMovingWorld(EntityPlayer player, EntityMovingWorld movingWorld, MountStage stage) {
    }

    public void func_145839_a(NBTTagCompound tag) {
        int id;
        Entity entity;
        super.func_145839_a(tag);
        this.getInfo().setName(tag.func_74779_i("name"));
        if (tag.func_74764_b("owner")) {
            this.getInfo().setOwner(UUID.fromString(tag.func_74779_i("owner")));
        }
        this.field_145847_g = tag.func_74762_e("meta");
        if (tag.func_74764_b("ship") && this.field_145850_b != null && (entity = this.field_145850_b.func_73045_a(id = tag.func_74762_e("ship"))) instanceof EntityMovingWorld) {
            this.setParentMovingWorld((EntityMovingWorld)entity);
        }
        if (tag.func_74764_b("res")) {
            this.assembleResult = new AssembleResult(tag.func_74775_l("res"), this.field_145850_b);
            this.assembleResult.assemblyInteractor = this.getNewAssemblyInteractor().fromNBT(tag.func_74775_l("res"), this.field_145850_b);
        }
        if (tag.func_74764_b("removedFluidCompounds")) {
            this.removedFluidBlocks = new LocatedBlockList();
            NBTTagCompound removedFluidCompound = tag.func_74775_l("removedFluidCompounds");
            int tagIndex = 0;
            while (removedFluidCompound.func_74764_b("block#" + tagIndex)) {
                NBTTagCompound lbTag = removedFluidCompound.func_74775_l("block#" + tagIndex);
                LocatedBlock locatedBlock = new LocatedBlock(lbTag, this.field_145850_b);
                this.removedFluidBlocks.add(locatedBlock);
                ++tagIndex;
            }
            tag.func_74782_a("removedFluidCompounds", (NBTBase)new NBTTagCompound());
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag = super.func_189515_b(tag);
        tag.func_74778_a("name", this.getInfo().getName());
        if (this.getInfo().getOwner() != null) {
            tag.func_74778_a("owner", this.getInfo().getOwner().toString());
        }
        tag.func_74768_a("meta", this.field_145847_g);
        tag.func_74778_a("name", this.getInfo().getName());
        if (this.getParentMovingWorld() != null && !this.getParentMovingWorld().field_70128_L) {
            tag.func_74768_a("movingWorld", this.getParentMovingWorld().func_145782_y());
        }
        if (this.assembleResult != null) {
            NBTTagCompound comp = new NBTTagCompound();
            this.assembleResult.writeNBTFully(comp);
            this.assembleResult.assemblyInteractor.writeNBTFully(comp);
            tag.func_74782_a("res", (NBTBase)comp);
        }
        if (this.removedFluidBlocks != null && !this.removedFluidBlocks.isEmpty()) {
            NBTTagCompound removedFluidCompound = new NBTTagCompound();
            for (int i = 0; i < this.removedFluidBlocks.size(); ++i) {
                LocatedBlock locatedBlock = (LocatedBlock)this.removedFluidBlocks.get(i);
                NBTTagCompound lbTag = new NBTTagCompound();
                locatedBlock.writeToNBT(lbTag);
                removedFluidCompound.func_74782_a("block#" + i, (NBTBase)lbTag);
            }
            tag.func_74782_a("removedFluidCompounds", (NBTBase)removedFluidCompound);
        }
        return tag;
    }

    public void writeNBTForSending(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74768_a("meta", this.field_145847_g);
        tag.func_74778_a("name", this.getInfo().getName());
        if (this.getParentMovingWorld() != null && !this.getParentMovingWorld().field_70128_L) {
            tag.func_74768_a("movingWorld", this.getParentMovingWorld().func_145782_y());
        }
        if (this.assembleResult != null) {
            NBTTagCompound comp = new NBTTagCompound();
            this.assembleResult.writeNBTMetadata(comp);
            this.assembleResult.assemblyInteractor.writeNBTMetadata(comp);
            tag.func_74782_a("res", (NBTBase)comp);
        }
    }

    public static enum MountStage {
        PREMSG,
        PRERIDE,
        POSTRIDE;

    }
}

