/*
 * Decompiled with CFR 0.152.
 */
package io.github.elytra.movingworld.common.util;

import com.google.common.collect.HashBiMap;
import io.github.elytra.movingworld.MovingWorldMod;
import io.github.elytra.movingworld.common.chunk.LocatedBlock;
import java.util.ArrayList;
import net.minecraft.util.math.BlockPos;

public class LocatedBlockList
extends ArrayList<LocatedBlock> {
    private HashBiMap<BlockPos, LocatedBlock> posMap;

    public LocatedBlockList() {
        this.posMap = HashBiMap.create();
    }

    public LocatedBlockList(int initialSize) {
        super(initialSize);
    }

    @Override
    public boolean add(LocatedBlock locatedBlock) {
        if (!this.posMap.containsKey((Object)locatedBlock.blockPos)) {
            this.posMap.put((Object)locatedBlock.blockPos, (Object)locatedBlock);
        }
        return super.add(locatedBlock);
    }

    @Override
    public void add(int index, LocatedBlock locatedBlock) {
        if (!this.posMap.containsKey((Object)locatedBlock.blockPos)) {
            this.posMap.put((Object)locatedBlock.blockPos, (Object)locatedBlock);
        }
        super.add(index, locatedBlock);
    }

    public ArrayList<LocatedBlockList> getSortedAssemblyBlocks() {
        ArrayList<LocatedBlockList> lbListList = new ArrayList<LocatedBlockList>();
        lbListList.add(this.getHighPriorityAssemblyBlocks());
        lbListList.add(this.getStandardPriorityAssemblyBlocks());
        lbListList.add(this.getLowPriorityAssemblyBlocks());
        return lbListList;
    }

    public ArrayList<LocatedBlockList> getSortedDisassemblyBlocks() {
        ArrayList<LocatedBlockList> lbListList = new ArrayList<LocatedBlockList>();
        lbListList.add(this.getHighPriorityDisassemblyBlocks());
        lbListList.add(this.getStandardPriorityDisassemblyBlocks());
        lbListList.add(this.getLowPriorityDisassemblyBlocks());
        return lbListList;
    }

    public LocatedBlockList getHighPriorityAssemblyBlocks() {
        LocatedBlockList thisList = new LocatedBlockList();
        thisList.addAll(this);
        LocatedBlockList lbList = new LocatedBlockList();
        if (!thisList.isEmpty()) {
            for (LocatedBlock lb : thisList) {
                if (!MovingWorldMod.INSTANCE.getNetworkConfig().getShared().assemblePriorityConfig.getHighPriorityAssembly().contains(lb.getBlockName())) continue;
                lbList.add(lb);
            }
        }
        return lbList;
    }

    public LocatedBlockList getHighPriorityDisassemblyBlocks() {
        LocatedBlockList thisList = new LocatedBlockList();
        thisList.addAll(this);
        LocatedBlockList lbList = new LocatedBlockList();
        if (!thisList.isEmpty()) {
            for (LocatedBlock lb : thisList) {
                if (!MovingWorldMod.INSTANCE.getNetworkConfig().getShared().assemblePriorityConfig.getHighPriorityDisassembly().contains(lb.getBlockName())) continue;
                lbList.add(lb);
            }
        }
        return lbList;
    }

    public LocatedBlockList getLowPriorityAssemblyBlocks() {
        LocatedBlockList thisList = new LocatedBlockList();
        thisList.addAll(this);
        LocatedBlockList lbList = new LocatedBlockList();
        if (!thisList.isEmpty()) {
            for (LocatedBlock lb : thisList) {
                if (!MovingWorldMod.INSTANCE.getNetworkConfig().getShared().assemblePriorityConfig.getLowPriorityAssembly().contains(lb.getBlockName())) continue;
                lbList.add(lb);
            }
        }
        return lbList;
    }

    public LocatedBlockList getLowPriorityDisassemblyBlocks() {
        LocatedBlockList thisList = new LocatedBlockList();
        thisList.addAll(this);
        LocatedBlockList lbList = new LocatedBlockList();
        if (!thisList.isEmpty()) {
            for (LocatedBlock lb : thisList) {
                if (!MovingWorldMod.INSTANCE.getNetworkConfig().getShared().assemblePriorityConfig.getLowPriorityDisassembly().contains(lb.getBlockName())) continue;
                lbList.add(lb);
            }
        }
        return lbList;
    }

    public LocatedBlockList getStandardPriorityAssemblyBlocks() {
        LocatedBlockList thisList = new LocatedBlockList();
        thisList.addAll(this);
        LocatedBlockList lbList = new LocatedBlockList();
        if (!thisList.isEmpty()) {
            for (LocatedBlock lb : thisList) {
                if (MovingWorldMod.INSTANCE.getNetworkConfig().getShared().assemblePriorityConfig.getHighPriorityAssembly().contains(lb.getBlockName()) || MovingWorldMod.INSTANCE.getNetworkConfig().getShared().assemblePriorityConfig.getLowPriorityAssembly().contains(lb.getBlockName())) continue;
                lbList.add(lb);
            }
        }
        return lbList;
    }

    public LocatedBlockList getStandardPriorityDisassemblyBlocks() {
        LocatedBlockList thisList = new LocatedBlockList();
        thisList.addAll(this);
        LocatedBlockList lbList = new LocatedBlockList();
        if (!thisList.isEmpty()) {
            for (LocatedBlock lb : thisList) {
                if (MovingWorldMod.INSTANCE.getNetworkConfig().getShared().assemblePriorityConfig.getHighPriorityDisassembly().contains(lb.getBlockName()) || MovingWorldMod.INSTANCE.getNetworkConfig().getShared().assemblePriorityConfig.getLowPriorityDisassembly().contains(lb.getBlockName())) continue;
                lbList.add(lb);
            }
        }
        return lbList;
    }

    public LocatedBlock getLBOfPos(BlockPos pos) {
        return (LocatedBlock)this.posMap.get((Object)pos);
    }

    public boolean containsLBOfPos(BlockPos pos) {
        return this.posMap.containsKey((Object)pos);
    }
}

