/*
 * Decompiled with CFR 0.152.
 */
package io.github.elytra.movingworld.common.util;

import io.github.elytra.movingworld.MovingWorldMod;
import io.github.elytra.movingworld.api.rotation.IRotationBlock;
import io.github.elytra.movingworld.api.rotation.IRotationProperty;
import io.github.elytra.movingworld.common.chunk.LocatedBlock;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.Vec3i;

public class RotationHelper {
    public static LocatedBlock rotateBlock(LocatedBlock locatedBlock, boolean ccw) {
        IBlockState blockState = locatedBlock.blockState;
        if (locatedBlock != null && locatedBlock.blockState != null) {
            if (blockState.func_177230_c() != null && blockState.func_177230_c() instanceof IRotationBlock) {
                locatedBlock = ((IRotationBlock)blockState.func_177230_c()).rotate(locatedBlock, ccw);
                if (((IRotationBlock)blockState.func_177230_c()).fullRotation()) {
                    return locatedBlock;
                }
            }
            for (IProperty prop : blockState.func_177228_b().keySet()) {
                if (!(prop instanceof IRotationProperty)) continue;
                MovingWorldMod.LOG.debug("Rotate state in " + blockState.func_177230_c().func_149732_F() + " " + blockState.func_177229_b(prop));
                IRotationProperty rotationProperty = (IRotationProperty)prop;
                blockState = rotationProperty.rotate(blockState, ccw);
                MovingWorldMod.LOG.debug("Rotate state out " + blockState.func_177230_c().func_149732_F() + " " + blockState.func_177229_b(prop));
            }
        }
        return new LocatedBlock(blockState, locatedBlock.tileEntity, locatedBlock.blockPos, locatedBlock.bPosNoOffset);
    }

    public static int rotateInteger(int integer, int min, int max, boolean ccw) {
        int result = integer;
        result = !ccw ? (result + 1 > max ? min : ++result) : (result - 1 < min ? max : --result);
        return result;
    }

    public static Vec3i getDirectionVec(EnumFacing facing) {
        switch (facing) {
            case DOWN: {
                return new Vec3i(0, -1, 0);
            }
            case UP: {
                return new Vec3i(0, 1, 0);
            }
            case NORTH: {
                return new Vec3i(0, 0, -1);
            }
            case SOUTH: {
                return new Vec3i(0, 0, 1);
            }
            case WEST: {
                return new Vec3i(-1, 0, 0);
            }
            case EAST: {
                return new Vec3i(1, 0, 0);
            }
        }
        return null;
    }
}

