/*
 * Decompiled with CFR 0.152.
 */
package io.github.elytra.movingworld.repackage.com.unascribed.lambdanetwork;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.github.elytra.movingworld.repackage.com.unascribed.lambdanetwork.LambdaNetwork;
import io.github.elytra.movingworld.repackage.com.unascribed.lambdanetwork.PacketSpec;
import java.util.List;
import java.util.Map;

public class LambdaNetworkBuilder {
    private Map<String, List<PacketSpec>> packets = Maps.newHashMap();
    protected String currentChannel;

    protected void addPacket(PacketSpec builder) {
        List<Object> li;
        if (this.packets.containsKey(this.currentChannel)) {
            li = this.packets.get(this.currentChannel);
        } else {
            li = Lists.newArrayList();
            this.packets.put(this.currentChannel, (List<PacketSpec>)li);
        }
        li.add(builder);
    }

    public LambdaNetworkBuilder channel(String channel) {
        this.currentChannel = channel;
        return this;
    }

    public PacketSpec packet(String identifier) {
        if (this.currentChannel == null) {
            throw new IllegalArgumentException("Cannot add packets without a channel!");
        }
        return PacketSpec.mutableBuilder(this, identifier);
    }

    public LambdaNetwork build() {
        return new LambdaNetwork(this.packets);
    }
}

