/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.injection.points;

import java.util.Collection;
import java.util.ListIterator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.lib.tree.InsnList;
import org.spongepowered.asm.lib.tree.MethodInsnNode;
import org.spongepowered.asm.mixin.injection.InjectionPoint;
import org.spongepowered.asm.mixin.injection.struct.InjectionPointData;
import org.spongepowered.asm.mixin.injection.struct.MemberInfo;

@InjectionPoint.AtCode(value="INVOKE")
public class BeforeInvoke
extends InjectionPoint {
    protected final MemberInfo target;
    protected final int ordinal;
    protected boolean logging = false;
    protected final Logger logger = LogManager.getLogger((String)"mixin");
    protected final String className;

    public BeforeInvoke(InjectionPointData data) {
        super(data);
        this.target = data.getTarget();
        this.ordinal = data.getOrdinal();
        this.logging = data.get("log", false);
        this.className = this.getClass().getSimpleName();
    }

    public BeforeInvoke setLogging(boolean logging) {
        this.logging = logging;
        return this;
    }

    @Override
    public boolean find(String desc, InsnList insns, Collection<AbstractInsnNode> nodes) {
        int ordinal = 0;
        boolean found = false;
        if (this.logging) {
            this.logger.info("{} is searching for an injection point in method with descriptor {}", new Object[]{this.className, desc});
        }
        ListIterator<AbstractInsnNode> iter = insns.iterator();
        while (iter.hasNext()) {
            AbstractInsnNode insn = iter.next();
            if (this.matchesInsn(insn)) {
                MemberInfo nodeInfo = new MemberInfo(insn);
                if (this.logging) {
                    this.logger.info("{} is considering insn {}", new Object[]{this.className, nodeInfo});
                }
                if (this.target.matches(nodeInfo.owner, nodeInfo.name, nodeInfo.desc)) {
                    if (this.logging) {
                        this.logger.info("{} > found a matching insn, checking preconditions...", new Object[]{this.className});
                    }
                    if (this.matchesInsn(nodeInfo, ordinal)) {
                        if (this.logging) {
                            this.logger.info("{} > > > found a matching insn at ordinal {}", new Object[]{this.className, ordinal});
                        }
                        found |= this.addInsn(insns, nodes, insn);
                        if (this.ordinal == ordinal) break;
                    }
                    ++ordinal;
                }
            }
            this.inspectInsn(desc, insns, insn);
        }
        return found;
    }

    protected boolean addInsn(InsnList insns, Collection<AbstractInsnNode> nodes, AbstractInsnNode insn) {
        nodes.add(insn);
        return true;
    }

    protected boolean matchesInsn(AbstractInsnNode insn) {
        return insn instanceof MethodInsnNode;
    }

    protected void inspectInsn(String desc, InsnList insns, AbstractInsnNode insn) {
    }

    protected boolean matchesInsn(MemberInfo nodeInfo, int ordinal) {
        if (this.logging) {
            this.logger.info("{} > > comparing target ordinal {} with current ordinal {}", new Object[]{this.className, this.ordinal, ordinal});
        }
        return this.ordinal == -1 || this.ordinal == ordinal;
    }
}

