/*
 * Decompiled with CFR 0.152.
 */
package io.github.elytra.movingworld.common.chunk;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class LocatedBlock {
    public static final LocatedBlock AIR = new LocatedBlock(Blocks.field_150350_a.func_176223_P(), BlockPos.field_177992_a);
    public final IBlockState blockState;
    public final TileEntity tileEntity;
    public final BlockPos blockPos;
    public final BlockPos bPosNoOffset;

    public LocatedBlock(IBlockState blockState, BlockPos blockPos) {
        this(blockState, null, blockPos);
    }

    public LocatedBlock(IBlockState blockState, TileEntity tileentity, BlockPos blockPos) {
        this(blockState, tileentity, blockPos, null);
    }

    public LocatedBlock(IBlockState blockState, TileEntity tileentity, BlockPos blockPos, BlockPos bPosNoOffset) {
        this.blockState = blockState;
        this.blockPos = blockPos;
        this.bPosNoOffset = bPosNoOffset;
        this.tileEntity = tileentity;
    }

    public LocatedBlock(NBTTagCompound tag, World world) {
        this.blockState = Block.func_149729_e((int)tag.func_74762_e("block")).func_176223_P().func_177230_c().func_176203_a(tag.func_74762_e("meta"));
        this.blockPos = new BlockPos(tag.func_74762_e("x"), tag.func_74762_e("y"), tag.func_74762_e("z"));
        this.bPosNoOffset = null;
        this.tileEntity = world == null ? null : world.func_175625_s(new BlockPos(this.blockPos.func_177958_n(), this.blockPos.func_177956_o(), this.blockPos.func_177952_p()));
    }

    public String toString() {
        return "LocatedBlock [block=" + this.blockState.func_177230_c() + ", state=" + this.blockState.toString() + ", blockPos=[" + this.blockPos.func_177958_n() + ", " + this.blockPos.func_177956_o() + ", " + this.blockPos.func_177952_p() + "]]";
    }

    public LocatedBlock clone() {
        return new LocatedBlock(this.blockState, this.tileEntity, this.blockPos, this.bPosNoOffset);
    }

    public String getBlockName() {
        return ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)this.blockState.func_177230_c())).toString();
    }

    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74777_a("block", (short)Block.func_149682_b((Block)this.blockState.func_177230_c()));
        tag.func_74768_a("meta", this.blockState.func_177230_c().func_176201_c(this.blockState));
        tag.func_74768_a("x", this.blockPos.func_177958_n());
        tag.func_74768_a("y", this.blockPos.func_177956_o());
        tag.func_74768_a("z", this.blockPos.func_177952_p());
    }
}

