/*
 * Decompiled with CFR 0.152.
 */
package io.github.elytra.movingworld.common.config;

import io.github.elytra.movingworld.MovingWorldMod;
import io.github.elytra.movingworld.common.config.priority.AssemblePriorityConfig;
import io.github.elytra.movingworld.common.util.MaterialDensity;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Pattern;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class MainConfig {
    private Configuration config;
    private SharedConfig shared;
    private boolean allowListInsertion;

    public MainConfig(Configuration config) {
        this.config = config;
        this.shared = new SharedConfig();
        this.shared.assemblePriorityConfig = new AssemblePriorityConfig(new Configuration(new File(config.getConfigFile().getParentFile(), "AssemblePriority.cfg")));
        this.shared.blockBlacklist = new HashSet<String>();
        this.shared.blockWhitelist = new HashSet<String>();
        this.shared.overwritableBlocks = new HashSet<String>();
        this.shared.updatableTiles = new HashSet<String>();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public SharedConfig getShared() {
        return this.shared;
    }

    public void setShared(SharedConfig shared) {
        this.shared = shared;
    }

    public Configuration getConfig() {
        return this.config;
    }

    private Block[] getDefaultBlockWhiteList() {
        return new Block[]{Blocks.field_150400_ck, Blocks.field_150408_cc, Blocks.field_150467_bQ, Blocks.field_150324_C, Blocks.field_150487_bG, Blocks.field_150342_X, Blocks.field_150382_bo, Blocks.field_150336_V, Blocks.field_150389_bf, Blocks.field_150434_aF, Blocks.field_150414_aQ, Blocks.field_150404_cg, Blocks.field_150402_ci, Blocks.field_150347_e, Blocks.field_150463_bK, Blocks.field_150483_bI, Blocks.field_150462_ai, Blocks.field_150401_cl, Blocks.field_150319_E, Blocks.field_150484_ah, Blocks.field_150367_z, Blocks.field_150409_cd, Blocks.field_150453_bW, Blocks.field_150334_T, Blocks.field_150373_bw, Blocks.field_150475_bE, Blocks.field_150381_bn, Blocks.field_150377_bs, Blocks.field_150477_bB, Blocks.field_180405_aT, Blocks.field_180404_aQ, Blocks.field_180406_aS, Blocks.field_180403_aR, Blocks.field_150386_bk, Blocks.field_180407_aO, Blocks.field_180408_aP, Blocks.field_180387_bt, Blocks.field_180392_bq, Blocks.field_180385_bs, Blocks.field_180386_br, Blocks.field_180390_bo, Blocks.field_180391_bp, Blocks.field_150457_bL, Blocks.field_150460_al, Blocks.field_150480_ab, Blocks.field_150359_w, Blocks.field_150410_aZ, Blocks.field_150426_aN, Blocks.field_150340_R, Blocks.field_150318_D, Blocks.field_150405_ch, Blocks.field_150407_cf, Blocks.field_150443_bT, Blocks.field_150438_bZ, Blocks.field_150411_aY, Blocks.field_150339_S, Blocks.field_150454_av, Blocks.field_150421_aI, Blocks.field_150481_bH, Blocks.field_150468_ap, Blocks.field_150368_y, Blocks.field_150442_at, Blocks.field_150445_bS, Blocks.field_150470_am, Blocks.field_150428_aP, Blocks.field_150374_bv, Blocks.field_150364_r, Blocks.field_150363_s, Blocks.field_150440_ba, Blocks.field_150474_ac, Blocks.field_150418_aU, Blocks.field_150341_Y, Blocks.field_150385_bj, Blocks.field_150386_bk, Blocks.field_150387_bl, Blocks.field_150323_B, Blocks.field_150476_ad, Blocks.field_150343_Z, Blocks.field_150344_f, Blocks.field_150423_aK, Blocks.field_150331_J, Blocks.field_180384_M, Blocks.field_150332_K, Blocks.field_150455_bV, Blocks.field_150416_aS, Blocks.field_150371_ca, Blocks.field_150370_cb, Blocks.field_150448_aq, Blocks.field_150451_bX, Blocks.field_150429_aA, Blocks.field_150488_af, Blocks.field_150322_A, Blocks.field_150372_bz, Blocks.field_180395_cM, Blocks.field_180396_cN, Blocks.field_150465_bP, Blocks.field_150360_v, Blocks.field_150485_bF, Blocks.field_150406_ce, Blocks.field_150472_an, Blocks.field_150390_bg, Blocks.field_150430_aB, Blocks.field_150456_au, Blocks.field_150446_ar, Blocks.field_150417_aV, Blocks.field_150399_cn, Blocks.field_150397_co, Blocks.field_150320_F, Blocks.field_150333_U, Blocks.field_180389_cP, Blocks.field_150335_W, Blocks.field_150478_aa, Blocks.field_150415_aT, Blocks.field_150447_bR, Blocks.field_150473_bD, Blocks.field_150479_bC, Blocks.field_150437_az, Blocks.field_150441_bU, Blocks.field_150413_aR, Blocks.field_150444_as, Blocks.field_150321_G, Blocks.field_150471_bO, Blocks.field_180410_as, Blocks.field_180412_aq, Blocks.field_180409_at, Blocks.field_180411_ar, Blocks.field_180413_ao, Blocks.field_180414_ap, Blocks.field_150452_aw, Blocks.field_150325_L, Blocks.field_150376_bx};
    }

    private Block[] getDefaultBlockBlackList() {
        return new Block[]{Blocks.field_150346_d, Blocks.field_150349_c, Blocks.field_150354_m, Blocks.field_150351_n, Blocks.field_150435_aG, Blocks.field_150432_aD, Blocks.field_150355_j, Blocks.field_150358_i, Blocks.field_150353_l, Blocks.field_150356_k, Blocks.field_150433_aE, Blocks.field_150431_aC, Blocks.field_150392_bi, Blocks.field_150424_aL, Blocks.field_150425_aM, Blocks.field_150329_H};
    }

    public void loadAndSave() {
        String[] defaultMaterialDensities = new String[]{"\"minecraft:air=0.0\"", "\"minecraft:wool=0.1\""};
        String[] defaultBlockDensities = new String[]{"\"ArchimedesShipsPlus:floater=0.04\"", "\"ArchimedesShipsPlus:balloon=0.02\""};
        String[] defaultUpdatableTiles = new String[]{"Furnace", "Hopper", "Banner", "EnchantTable", "DLDetector"};
        Block[] defaultOverWritableBlocks = new Block[]{Blocks.field_150329_H, Blocks.field_150392_bi, Blocks.field_150431_aC};
        String[] blockBlackListNames = new String[this.getDefaultBlockBlackList().length];
        for (int i = 0; i < this.getDefaultBlockBlackList().length; ++i) {
            blockBlackListNames[i] = ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)this.getDefaultBlockBlackList()[i])).toString();
        }
        String[] blockWhiteListNames = new String[this.getDefaultBlockWhiteList().length];
        for (int i = 0; i < blockWhiteListNames.length; ++i) {
            blockWhiteListNames[i] = ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)this.getDefaultBlockWhiteList()[i])).toString();
        }
        String[] overWritableBlockNames = new String[defaultOverWritableBlocks.length];
        for (int i = 0; i < defaultOverWritableBlocks.length; ++i) {
            overWritableBlockNames[i] = ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)defaultOverWritableBlocks[i])).toString();
        }
        this.config.load();
        this.shared.iterativeAlgorithm = this.config.get("general", "Use Iterative Algorithm", true).getBoolean();
        this.shared.diagonalAssembly = this.config.get("general", "Assemble Diagonal Blocks NOTE: Can be overridden by mods!", false).getBoolean();
        this.shared.useWhitelist = this.config.get("mobile_chunk", "use_whitelist", false, "Switch this property to select the block restriction list to use. 'true' for the 'allowed_blocks' whitelist, 'false' for the 'forbidden_blocks' blacklist.").getBoolean(false);
        SharedConfig.access$002(this.shared, this.config.get("mobile_chunk", "block_densities", defaultBlockDensities, "A list of pairs of a block with a density value. This list overrides the 'material_densities' list.").getStringList());
        SharedConfig.access$102(this.shared, this.config.get("mobile_chunk", "material_densities", defaultMaterialDensities, "A list of pairs of a material with a density value. The first value is the name of a block. All objects with the same material will get this density value, unless overridden.").getStringList());
        this.allowListInsertion = this.config.get("general", "Allow other mods to add to the whitelist/blacklist? NOTE: Turn off if you want to remove the default blacklist/whitelist", true).getBoolean();
        String[] forbiddenBlocks = this.config.get("mobile_chunk", "forbidden_blocks", blockBlackListNames, "A list of blocks that will not be added to a Moving World.").getStringList();
        String[] allowedBlocks = this.config.get("mobile_chunk", "allowed_blocks", blockWhiteListNames, "A list of blocks that are allowed on a Moving World.").getStringList();
        String[] overwritableBlocks = this.config.get("mobile_chunk", "overwritable_blocks", overWritableBlockNames, "A list of blocks that may be overwritten when decompiling a Moving World.").getStringList();
        String[] updatableTiles = this.config.get("mobile_chunk", "updatable_tiles", defaultUpdatableTiles, "(Currently unimplemented) A list of tiles that are allowed to tick while they're part of a MobileChunk, might cause explosive loss of data, type 2 diabetes, and cancer. Use with caution.").getStringList();
        Collections.addAll(this.shared.blockBlacklist, forbiddenBlocks);
        Collections.addAll(this.shared.blockWhitelist, allowedBlocks);
        Collections.addAll(this.shared.overwritableBlocks, overwritableBlocks);
        Collections.addAll(this.shared.updatableTiles, updatableTiles);
        this.config.save();
        this.shared.assemblePriorityConfig.loadAndSavePreInit();
    }

    public void postLoad() {
        Block block;
        float density;
        String key;
        String[] pair;
        String s;
        int i;
        Pattern splitpattern = Pattern.compile("=");
        for (i = 0; i < this.shared.loadedBlockDensities.length; ++i) {
            s = this.shared.loadedBlockDensities[i];
            pair = splitpattern.split(s = s.replace("\"", ""));
            if (pair.length != 2) {
                MovingWorldMod.LOG.warn("Invalid key-value pair at block_densities[" + i + "]");
                continue;
            }
            key = pair[0];
            try {
                density = Float.parseFloat(pair[1]);
            }
            catch (NumberFormatException e) {
                MovingWorldMod.LOG.warn("Cannot parse value " + pair[1] + " to floating point at block_densities[" + i + "]");
                continue;
            }
            block = Block.func_149684_b((String)key);
            if (block == null) {
                MovingWorldMod.LOG.warn("No block found for " + key + " at block_densities[" + i + "]");
                continue;
            }
            MaterialDensity.addDensity(block, density);
        }
        for (i = 0; i < this.shared.loadedMaterialDensities.length; ++i) {
            s = this.shared.loadedMaterialDensities[i];
            pair = splitpattern.split(s = s.replace("\"", ""));
            if (pair.length != 2) {
                MovingWorldMod.LOG.warn("Invalid key-value pair at material_densities[" + i + "]");
                continue;
            }
            key = pair[0];
            try {
                density = Float.parseFloat(pair[1]);
            }
            catch (NumberFormatException e) {
                MovingWorldMod.LOG.warn("Cannot parse value " + pair[1] + " to floating point at material_densities[" + i + "]");
                continue;
            }
            block = Block.func_149684_b((String)key);
            if (block == null) {
                MovingWorldMod.LOG.warn("No block found for " + key + " at material_densities[" + i + "]");
                continue;
            }
            MaterialDensity.addDensity(block.func_176223_P().func_185904_a(), density);
        }
    }

    public void addBlacklistedBlock(Block block) {
        if (!this.allowListInsertion) {
            return;
        }
        String blockName = ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)block)).toString();
        this.config.load();
        String[] blockBlackListNames = new String[this.getDefaultBlockBlackList().length];
        for (int i = 0; i < this.getDefaultBlockBlackList().length; ++i) {
            blockBlackListNames[i] = ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)this.getDefaultBlockBlackList()[i])).toString();
        }
        Property prop = this.config.get("mobile_chunk", "forbidden_blocks", blockBlackListNames, "A list of blocks that will not be added to a Moving World.");
        String[] stringList = prop.getStringList();
        ArrayList<String> stringArrayList = new ArrayList<String>();
        Collections.addAll(stringArrayList, stringList);
        if (!stringArrayList.contains(blockName)) {
            stringArrayList.add(blockName);
        }
        String[] setVal = new String[stringArrayList.size()];
        int i = 0;
        Iterator iterator = stringArrayList.iterator();
        while (iterator.hasNext()) {
            String str;
            setVal[i] = str = (String)iterator.next();
            ++i;
        }
        prop.set(setVal);
        this.config.save();
    }

    public void addWhitelistedBlock(Block block) {
        if (!this.allowListInsertion) {
            return;
        }
        String blockName = ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)block)).toString();
        this.config.load();
        String[] blockWhiteListNames = new String[this.getDefaultBlockWhiteList().length];
        for (int i = 0; i < blockWhiteListNames.length; ++i) {
            blockWhiteListNames[i] = ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)this.getDefaultBlockWhiteList()[i])).toString();
        }
        Property prop = this.config.get("mobile_chunk", "allowed_blocks", blockWhiteListNames, "A list of blocks that are allowed on a Moving World.");
        String[] stringList = prop.getStringList();
        ArrayList<String> stringArrayList = new ArrayList<String>();
        Collections.addAll(stringArrayList, stringList);
        if (!stringArrayList.contains(blockName)) {
            stringArrayList.add(blockName);
        }
        String[] setVal = new String[stringArrayList.size()];
        int i = 0;
        Iterator iterator = stringArrayList.iterator();
        while (iterator.hasNext()) {
            String str;
            setVal[i] = str = (String)iterator.next();
            ++i;
        }
        prop.set(setVal);
        this.config.save();
    }

    public boolean isStateAllowed(IBlockState state) {
        String id = ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)state.func_177230_c())).toString();
        return this.shared.useWhitelist ? this.shared.blockWhitelist.contains(id) : !this.shared.blockBlacklist.contains(id);
    }

    public boolean canOverwriteState(IBlockState state) {
        return this.shared.overwritableBlocks.contains(Block.field_149771_c.func_177774_c((Object)state.func_177230_c()));
    }

    public boolean isTileUpdatable(Class<? extends TileEntity> tileClass) {
        return false;
    }

    @SubscribeEvent
    public void onConfigChange(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("movingworld")) {
            if (this.config.hasChanged()) {
                this.config.save();
            }
            this.loadAndSave();
        }
    }

    public class SharedConfig {
        public boolean iterativeAlgorithm;
        public boolean diagonalAssembly;
        public boolean useWhitelist;
        public Set<String> blockBlacklist;
        public Set<String> blockWhitelist;
        public Set<String> overwritableBlocks;
        public Set<String> updatableTiles;
        public AssemblePriorityConfig assemblePriorityConfig;
        private String[] loadedBlockDensities;
        private String[] loadedMaterialDensities;

        public NBTTagCompound serialize() {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74757_a("iterativeAlgorithm", this.iterativeAlgorithm);
            tag.func_74757_a("diagonalAssembly", this.diagonalAssembly);
            tag.func_74757_a("useWhitelist", this.useWhitelist);
            return tag;
        }

        public SharedConfig deserialize(NBTTagCompound tag) {
            SharedConfig sharedConfig = new SharedConfig();
            return sharedConfig;
        }

        static /* synthetic */ String[] access$002(SharedConfig x0, String[] x1) {
            x0.loadedBlockDensities = x1;
            return x1;
        }

        static /* synthetic */ String[] access$102(SharedConfig x0, String[] x1) {
            x0.loadedMaterialDensities = x1;
            return x1;
        }
    }
}

