/*
 * Decompiled with CFR 0.152.
 */
package io.github.elytra.movingworld.common.entity;

import io.github.elytra.movingworld.MovingWorldMod;
import io.github.elytra.movingworld.common.chunk.ChunkIO;
import io.github.elytra.movingworld.common.chunk.mobilechunk.MobileChunkServer;
import io.github.elytra.movingworld.common.entity.EntityMovingWorld;
import io.github.elytra.movingworld.common.entity.MovingWorldHandlerCommon;
import io.github.elytra.movingworld.common.network.MovingWorldNetworking;
import io.github.elytra.movingworld.common.tile.TileMovingMarkingBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;

public abstract class MovingWorldHandlerServer
extends MovingWorldHandlerCommon {
    protected boolean firstChunkUpdate = true;

    public MovingWorldHandlerServer(EntityMovingWorld entitymovingWorld) {
        super(entitymovingWorld);
    }

    @Override
    public boolean processInitialInteract(EntityPlayer player, ItemStack stack, EnumHand hand) {
        return false;
    }

    private MobileChunkServer getMobileChunkServer() {
        if (this.getMovingWorld() != null && this.getMovingWorld().getMobileChunk() != null && this.getMovingWorld().getMobileChunk().side().isServer()) {
            return (MobileChunkServer)this.getMovingWorld().getMobileChunk();
        }
        return null;
    }

    @Override
    public void onChunkUpdate() {
        super.onChunkUpdate();
        if (this.getMobileChunkServer() != null) {
            if (!this.firstChunkUpdate) {
                if (!this.getMobileChunkServer().getBlockQueue().isEmpty()) {
                    MovingWorldNetworking.NETWORK.send().packet("ChunkBlockUpdateMessage").with("dimID", this.getMovingWorld().field_70170_p.field_73011_w.getDimension()).with("entityID", this.getMovingWorld().func_145782_y()).with("chunk", ChunkIO.writeCompressed(this.getMovingWorld().getMobileChunk(), this.getMobileChunkServer().getBlockQueue())).toAllAround(this.getMovingWorld().field_70170_p, (Entity)this.getMovingWorld(), 64.0);
                    MovingWorldMod.LOG.debug("MobileChunk block change detected, sending packet to all within 64 blocks of " + this.getMovingWorld().toString());
                }
                if (!this.getMobileChunkServer().getTileQueue().isEmpty()) {
                    NBTTagCompound tagCompound = new NBTTagCompound();
                    NBTTagList list = new NBTTagList();
                    for (BlockPos tilePosition : this.getMobileChunkServer().getTileQueue()) {
                        NBTTagCompound nbt = new NBTTagCompound();
                        if (this.getMobileChunkServer().func_175625_s(tilePosition) == null) continue;
                        TileEntity te = this.getMobileChunkServer().func_175625_s(tilePosition);
                        if (te instanceof TileMovingMarkingBlock) {
                            ((TileMovingMarkingBlock)te).writeNBTForSending(nbt);
                        } else {
                            te.func_189515_b(nbt);
                        }
                        list.func_74742_a((NBTBase)nbt);
                    }
                    tagCompound.func_74782_a("list", (NBTBase)list);
                    MovingWorldNetworking.NETWORK.send().packet("TileEntitiesMessage").with("dimID", this.getMovingWorld().field_71093_bK).with("entityID", this.getMovingWorld().func_145782_y()).with("tagCompound", tagCompound).toAllAround(this.getMovingWorld().field_70170_p, (Entity)this.getMovingWorld(), 64.0);
                    MovingWorldMod.LOG.debug("MobileChunk tile change detected, sending packet to all within 64 blocks of " + this.getMovingWorld().toString());
                }
            }
            this.getMobileChunkServer().getTileQueue().clear();
            this.getMobileChunkServer().getBlockQueue().clear();
        }
        this.firstChunkUpdate = false;
    }
}

