/*
 * Decompiled with CFR 0.152.
 */
package io.github.elytra.movingworld.repackage.com.unascribed.lambdanetwork;

import com.google.common.collect.Maps;
import io.github.elytra.movingworld.repackage.com.unascribed.lambdanetwork.PacketSpec;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;

public class Token {
    private PacketSpec packet;
    private Map<String, Object> data = Maps.newHashMap();

    public Token(PacketSpec spec) {
        this.packet = spec;
    }

    protected void putData(String key, Object value) {
        this.data.put(key, value);
    }

    public int getInt(String key) {
        if (!this.packet.getType(key).isValidForInteger()) {
            this.invalidType(key, "int");
        }
        return ((Number)this.data.get(key)).intValue();
    }

    public long getLong(String key) {
        if (!this.packet.getType(key).isValidForInteger()) {
            this.invalidType(key, "long");
        }
        return ((Number)this.data.get(key)).longValue();
    }

    public float getFloat(String key) {
        if (!this.packet.getType(key).isValidForInteger() && !this.packet.getType(key).isValidForFloating()) {
            this.invalidType(key, "float");
        }
        return ((Number)this.data.get(key)).floatValue();
    }

    public double getDouble(String key) {
        if (!this.packet.getType(key).isValidForInteger() && !this.packet.getType(key).isValidForFloating()) {
            this.invalidType(key, "double");
        }
        return ((Number)this.data.get(key)).doubleValue();
    }

    public boolean getBoolean(String key) {
        if (!this.packet.getType(key).isValidForBoolean()) {
            this.invalidType(key, "boolean");
        }
        return (Boolean)this.data.get(key);
    }

    public String getString(String key) {
        if (!this.packet.getType(key).isValidForString()) {
            this.invalidType(key, "String");
        }
        return String.valueOf(this.data.get(key));
    }

    public byte[] getData(String key) {
        if (!this.packet.getType(key).isValidForData()) {
            this.invalidType(key, "byte[]");
        }
        return (byte[])this.data.get(key);
    }

    public NBTTagCompound getNBT(String key) {
        if (!this.packet.getType(key).isValidForNBT()) {
            this.invalidType(key, "NBTTagCompound");
        }
        return (NBTTagCompound)this.data.get(key);
    }

    private void invalidType(String key, String type) {
        throw new IllegalArgumentException("Type " + type + " is not valid for '" + key + "' (data type " + (Object)((Object)this.packet.getType(key)) + ") in packet '" + this.packet.getIdentifier() + "'");
    }
}

