/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.transformer;

import org.spongepowered.asm.lib.ClassReader;
import org.spongepowered.asm.lib.ClassWriter;
import org.spongepowered.asm.mixin.transformer.ClassInfo;

public class MixinClassWriter
extends ClassWriter {
    private static final String JAVA_LANG_OBJECT = "java/lang/Object";

    public MixinClassWriter(int flags) {
        super(flags);
    }

    public MixinClassWriter(ClassReader classReader, int flags) {
        super(classReader, flags);
    }

    @Override
    protected String getCommonSuperClass(String type1, String type2) {
        ClassInfo t2;
        ClassInfo t1 = ClassInfo.forName(type1);
        if (t1.hasSuperClass(t2 = ClassInfo.forName(type2))) {
            return type2;
        }
        if (t2.hasSuperClass(t1)) {
            return type1;
        }
        if (t1.isInterface() || t2.isInterface()) {
            return JAVA_LANG_OBJECT;
        }
        do {
            if ((t1 = t1.getSuperClass()) != null) continue;
            return JAVA_LANG_OBJECT;
        } while (!t2.hasSuperClass(t1));
        return t1.getName();
    }
}

