/*
 * Decompiled with CFR 0.152.
 */
package io.github.elytra.davincisvessels;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ListMultimap;
import io.github.elytra.davincisvessels.client.ClientProxy;
import io.github.elytra.davincisvessels.common.CommonProxy;
import io.github.elytra.davincisvessels.common.DavincisVesselsConfig;
import io.github.elytra.davincisvessels.common.command.CommandASHelp;
import io.github.elytra.davincisvessels.common.command.CommandASTP;
import io.github.elytra.davincisvessels.common.command.CommandDisassembleNear;
import io.github.elytra.davincisvessels.common.command.CommandDisassembleShip;
import io.github.elytra.davincisvessels.common.command.CommandShipInfo;
import io.github.elytra.davincisvessels.common.entity.EntityParachute;
import io.github.elytra.davincisvessels.common.entity.EntitySeat;
import io.github.elytra.davincisvessels.common.entity.EntityShip;
import io.github.elytra.davincisvessels.common.handler.ConnectionHandler;
import io.github.elytra.davincisvessels.common.network.DavincisVesselsNetworking;
import io.github.elytra.davincisvessels.common.object.DavincisVesselsObjects;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.block.Block;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLMissingMappingsEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="davincisvessels", name="Davinci's Vessels", version="@DVESSELSVER@", dependencies="required-after:movingworld", guiFactory="io.github.elytra.davincisvessels.client.gui.DavincisVesselsGUIFactory")
public class DavincisVesselsMod {
    public static final String MOD_ID = "davincisvessels";
    public static final String MOD_VERSION = "@DVESSELSVER@";
    public static final String MOD_NAME = "Davinci's Vessels";
    public static final String RESOURCE_DOMAIN = "davincisvessels:";
    public static final String MOD_GUIFACTORY = "io.github.elytra.davincisvessels.client.gui.DavincisVesselsGUIFactory";
    public static final DavincisVesselsObjects OBJECTS = new DavincisVesselsObjects();
    @Mod.Instance(value="davincisvessels")
    public static DavincisVesselsMod INSTANCE;
    @SidedProxy(clientSide="io.github.elytra.davincisvessels.client.ClientProxy", serverSide="io.github.elytra.davincisvessels.common.CommonProxy")
    public static CommonProxy PROXY;
    public static Logger LOG;
    public static CreativeTabs CREATIVE_TAB;
    private DavincisVesselsConfig localConfig;

    public DavincisVesselsConfig getNetworkConfig() {
        if (FMLCommonHandler.instance().getSide().isClient() && ((ClientProxy)DavincisVesselsMod.PROXY).syncedConfig != null) {
            return ((ClientProxy)DavincisVesselsMod.PROXY).syncedConfig;
        }
        return this.localConfig;
    }

    public DavincisVesselsConfig getLocalConfig() {
        return this.localConfig;
    }

    @Mod.EventHandler
    public void preInitMod(FMLPreInitializationEvent event) {
        LOG = event.getModLog();
        MinecraftForge.EVENT_BUS.register((Object)this);
        OBJECTS.preInit(event);
        this.localConfig = new DavincisVesselsConfig(new Configuration(event.getSuggestedConfigurationFile()));
        this.localConfig.loadAndSave();
        this.localConfig.postLoad();
        PROXY.registerRenderers(event.getModState());
    }

    @Mod.EventHandler
    public void initMod(FMLInitializationEvent event) {
        DavincisVesselsNetworking.setupNetwork();
        OBJECTS.init(event);
        MinecraftForge.EVENT_BUS.register((Object)new ConnectionHandler());
        MinecraftForge.EVENT_BUS.register((Object)new ConnectionHandler());
        EntityRegistry.registerModEntity(EntityShip.class, (String)"shipmod", (int)1, (Object)this, (int)64, (int)this.localConfig.getShared().shipEntitySyncRate, (boolean)true);
        EntityRegistry.registerModEntity(EntitySeat.class, (String)"attachment.seat", (int)2, (Object)this, (int)64, (int)20, (boolean)false);
        EntityRegistry.registerModEntity(EntityParachute.class, (String)"parachute", (int)3, (Object)this, (int)32, (int)this.localConfig.getShared().shipEntitySyncRate, (boolean)true);
        PROXY.registerKeyHandlers(this.localConfig);
        PROXY.registerEventHandlers();
        PROXY.registerRenderers(event.getModState());
        this.localConfig.addBlacklistWhitelistEntries();
    }

    @Mod.EventHandler
    public void postInitMod(FMLPostInitializationEvent event) {
        PROXY.registerRenderers(event.getModState());
    }

    @Mod.EventHandler
    public void missingMappingsFound(FMLMissingMappingsEvent event) {
        ImmutableList missingMappingList;
        ListMultimap missing;
        if (event != null && event.getAll() != null && !event.getAll().isEmpty() && (missing = (ListMultimap)ReflectionHelper.getPrivateValue(FMLMissingMappingsEvent.class, (Object)event, (String[])new String[]{"missing"})) != null && (missingMappingList = ImmutableList.copyOf((Collection)missing.get((Object)"archimedesshipsplus"))) != null && !missingMappingList.isEmpty()) {
            Logger log = LogManager.getLogger((String)MOD_ID);
            log.info("ARCHIMEDES LEGACY MAPPINGS FOUND");
            for (FMLMissingMappingsEvent.MissingMapping mapping : missingMappingList) {
                if (mapping == null || mapping.type == null || mapping.name == null || mapping.name.isEmpty()) continue;
                String name = mapping.name.substring("archimedesshipsplus:".length());
                if (mapping.type == GameRegistry.Type.BLOCK) {
                    mapping.remap((Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(MOD_ID, name)));
                } else {
                    mapping.remap(Item.func_150898_a((Block)GameRegistry.findBlock((String)MOD_ID, (String)name)));
                }
                log.debug("archimedesshipsplus:" + name + " ~~~> " + MOD_ID + name);
            }
            log.info("REMAPPED TO DAVINCI'S VESSELS, ENJOY! ~Darkevilmac");
        }
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        this.registerASCommand(event, new CommandASHelp());
        this.registerASCommand(event, new CommandDisassembleShip());
        this.registerASCommand(event, new CommandShipInfo());
        this.registerASCommand(event, new CommandDisassembleNear());
        this.registerASCommand(event, new CommandASTP());
        Collections.sort(CommandASHelp.asCommands);
    }

    private void registerASCommand(FMLServerStartingEvent event, CommandBase commandbase) {
        event.registerServerCommand((ICommand)commandbase);
        CommandASHelp.asCommands.add(commandbase);
    }

    static {
        CREATIVE_TAB = new CreativeTabs("davincisTab"){

            public Item func_78016_d() {
                return Item.func_150898_a((Block)DavincisVesselsObjects.blockMarkShip);
            }
        };
    }
}

