/*
 * Decompiled with CFR 0.152.
 */
package io.github.elytra.movingworld.repackage.com.unascribed.lambdanetwork;

import com.google.common.collect.ImmutableMap;
import io.github.elytra.movingworld.repackage.com.unascribed.lambdanetwork.LambdaChannel;
import io.github.elytra.movingworld.repackage.com.unascribed.lambdanetwork.LambdaNetworkBuilder;
import io.github.elytra.movingworld.repackage.com.unascribed.lambdanetwork.PacketSpec;
import io.github.elytra.movingworld.repackage.com.unascribed.lambdanetwork.PendingPacket;
import java.util.List;
import java.util.Map;

public class LambdaNetwork {
    private LambdaChannel soleChannel;
    private final ImmutableMap<String, LambdaChannel> channels;

    public LambdaNetwork(Map<String, List<PacketSpec>> packets) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<String, List<PacketSpec>> en : packets.entrySet()) {
            LambdaChannel channel = new LambdaChannel(en.getKey(), en.getValue());
            builder.put((Object)en.getKey(), (Object)channel);
            if (packets.size() != 1) continue;
            this.soleChannel = channel;
        }
        this.channels = builder.build();
    }

    public PendingPacket send() {
        return new PendingPacket(this);
    }

    public static LambdaNetworkBuilder builder() {
        return new LambdaNetworkBuilder();
    }

    public LambdaChannel getChannel(String channel) {
        if (!this.channels.containsKey((Object)channel)) {
            throw new IllegalArgumentException("No such channel '" + channel + "'");
        }
        return (LambdaChannel)this.channels.get((Object)channel);
    }

    public int channelCount() {
        return this.channels.size();
    }

    public LambdaChannel getSoleChannel() {
        if (this.channels.size() > 1) {
            throw new IllegalStateException("Cannot get the sole channel when there are multiple");
        }
        return this.soleChannel;
    }
}

