/*
 * Decompiled with CFR 0.152.
 */
package io.github.elytra.movingworld.repackage.com.unascribed.lambdanetwork;

import com.google.common.base.Preconditions;
import com.google.common.collect.EnumMultiset;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multiset;
import io.github.elytra.movingworld.repackage.com.unascribed.lambdanetwork.BiConsumer;
import io.github.elytra.movingworld.repackage.com.unascribed.lambdanetwork.DataType;
import io.github.elytra.movingworld.repackage.com.unascribed.lambdanetwork.LambdaNetworkBuilder;
import io.github.elytra.movingworld.repackage.com.unascribed.lambdanetwork.PacketSpec$$Lambda$1;
import io.github.elytra.movingworld.repackage.com.unascribed.lambdanetwork.PacketSpec$$Lambda$2;
import io.github.elytra.movingworld.repackage.com.unascribed.lambdanetwork.PacketSpec$$Lambda$3;
import io.github.elytra.movingworld.repackage.com.unascribed.lambdanetwork.Token;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class PacketSpec {
    private final LambdaNetworkBuilder parent;
    private final String identifier;
    private final Map<String, DataType> data;
    private final Multiset<DataType> types;
    private final List<String> booleanKeys;
    private BiConsumer<EntityPlayer, Token> consumer;
    private Side side = null;
    private int minimumSize = 1;

    private PacketSpec(LambdaNetworkBuilder parent, String identifier) {
        this.data = Maps.newLinkedHashMap();
        this.types = EnumMultiset.create(DataType.class);
        this.parent = parent;
        this.identifier = identifier;
        this.booleanKeys = Lists.newArrayList();
    }

    private PacketSpec(PacketSpec in) {
        this.data = ImmutableMap.copyOf(in.data);
        this.types = ImmutableMultiset.copyOf(in.types);
        this.parent = null;
        this.identifier = in.identifier;
        this.consumer = in.consumer;
        this.side = in.side;
        this.booleanKeys = ImmutableList.copyOf(in.booleanKeys);
        this.minimumSize = in.minimumSize;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public Side getSide() {
        return this.side;
    }

    public DataType getType(String key) {
        if (!this.data.containsKey(key)) {
            throw new IllegalArgumentException("No such data '" + key + "'");
        }
        return this.data.get(key);
    }

    public BiConsumer<EntityPlayer, Token> getConsumer() {
        return this.consumer;
    }

    public int getAmountOfType(DataType type) {
        return this.types.count((Object)type);
    }

    public List<String> getBooleanKeys() {
        return this.booleanKeys;
    }

    public Map<String, DataType> getData() {
        return this.data;
    }

    public int getMinimumSize() {
        return this.minimumSize;
    }

    public static PacketSpec mutableBuilder(LambdaNetworkBuilder parent, String identifier) {
        return new PacketSpec(parent, identifier);
    }

    public static PacketSpec immutableClone(PacketSpec spec) {
        return new PacketSpec(spec);
    }

    public PacketSpec with(DataType type, String name) {
        if (this.parent == null) {
            this.illegalStateImmutableClone();
        }
        if (this.data.containsKey(name)) {
            this.illegalArgument("defined multiple data entries with the same name");
        }
        this.data.put(name, type);
        this.types.add((Object)type);
        if (type == DataType.BOOLEAN) {
            this.booleanKeys.add(name);
        }
        this.minimumSize += type.minimumSize;
        return this;
    }

    public PacketSpec boundTo(Side side) {
        if (this.parent == null) {
            this.illegalStateImmutableClone();
        }
        Preconditions.checkNotNull((Object)side);
        this.side = side;
        return this;
    }

    public LambdaNetworkBuilder handledBy(BiConsumer<EntityPlayer, Token> consumer) {
        if (this.parent == null) {
            this.illegalStateImmutableClone();
        }
        this.checkNull(this.side, "isn't bound to any side");
        this.checkNull(consumer, "can't have a null handler");
        this.consumer = consumer;
        this.parent.addPacket(this);
        return this.parent;
    }

    public LambdaNetworkBuilder handledOnMainThreadBy(BiConsumer<EntityPlayer, Token> consumer) {
        this.handledBy(PacketSpec$$Lambda$1.lambdaFactory$(this, consumer));
        return this.parent;
    }

    @SideOnly(value=Side.CLIENT)
    private static void doOnMainThreadClient(EntityPlayer e, Token t, BiConsumer<EntityPlayer, Token> consumer) {
        Minecraft.func_71410_x().func_152344_a(PacketSpec$$Lambda$2.lambdaFactory$(consumer, e, t));
    }

    private static void doOnMainThreadServer(EntityPlayer e, Token t, BiConsumer<EntityPlayer, Token> consumer) {
        ((WorldServer)e.field_70170_p).func_152344_a(PacketSpec$$Lambda$3.lambdaFactory$(consumer, e, t));
    }

    private void illegalStateImmutableClone() {
        throw new IllegalStateException("Cannot use builder methods on an immutable clone");
    }

    private void checkNull(Object o, String msg) {
        if (o == null) {
            this.illegalArgument(msg);
        }
    }

    private void illegalArgument(String msg) {
        throw new IllegalArgumentException("Packet '" + this.identifier + "' owned by '" + this.parent.currentChannel + "' " + msg + "!");
    }

    private /* synthetic */ void lambda$handledOnMainThreadBy$0(BiConsumer consumer, EntityPlayer e, Token t) {
        if (this.side.isClient()) {
            PacketSpec.doOnMainThreadClient(e, t, consumer);
        } else {
            PacketSpec.doOnMainThreadServer(e, t, consumer);
        }
    }

    static /* synthetic */ void access$lambda$0(PacketSpec packetSpec, BiConsumer biConsumer, EntityPlayer entityPlayer, Token token) {
        packetSpec.lambda$handledOnMainThreadBy$0(biConsumer, entityPlayer, token);
    }

    static /* synthetic */ void access$lambda$1(BiConsumer biConsumer, EntityPlayer entityPlayer, Token token) {
        biConsumer.accept(entityPlayer, token);
    }

    static /* synthetic */ void access$lambda$2(BiConsumer biConsumer, EntityPlayer entityPlayer, Token token) {
        biConsumer.accept(entityPlayer, token);
    }
}

