/*
 * Decompiled with CFR 0.152.
 */
package io.github.elytra.movingworld.repackage.com.unascribed.lambdanetwork;

import com.google.common.base.Predicates;
import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import io.github.elytra.movingworld.repackage.com.unascribed.lambdanetwork.LambdaChannel;
import io.github.elytra.movingworld.repackage.com.unascribed.lambdanetwork.LambdaNetwork;
import io.github.elytra.movingworld.repackage.com.unascribed.lambdanetwork.PacketSpec;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.INetHandlerPlayClient;
import net.minecraft.network.play.INetHandlerPlayServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PendingPacket {
    private LambdaNetwork owner;
    private LambdaChannel channel;
    private PacketSpec packet;
    private String packetId;
    private Map<String, Object> data = Maps.newHashMap();

    public PendingPacket(LambdaNetwork owner) {
        this.owner = owner;
        if (owner.channelCount() == 1) {
            this.channel = owner.getSoleChannel();
        }
    }

    public PacketSpec getPacket() {
        return this.packet;
    }

    public Map<String, ?> getData() {
        return this.data;
    }

    public PendingPacket packet(String packet) {
        if (this.channel != null) {
            this.packet = this.channel.getPacketSpec(packet);
        }
        this.packetId = packet;
        return this;
    }

    public PendingPacket onChannel(String channel) {
        this.channel = this.owner.getChannel(channel);
        if (this.packetId != null) {
            this.packet = this.channel.getPacketSpec(this.packetId);
        }
        return this;
    }

    public PendingPacket with(String key, int value) {
        this.checkHasPacket();
        if (!this.packet.getType(key).isValidForInteger()) {
            this.invalidType(key, "int");
        }
        this.data.put(key, value);
        return this;
    }

    public PendingPacket with(String key, long value) {
        this.checkHasPacket();
        if (!this.packet.getType(key).isValidForInteger()) {
            this.invalidType(key, "long");
        }
        this.data.put(key, value);
        return this;
    }

    public PendingPacket with(String key, boolean value) {
        this.checkHasPacket();
        if (!this.packet.getType(key).isValidForBoolean()) {
            this.invalidType(key, "boolean");
        }
        this.data.put(key, value);
        return this;
    }

    public PendingPacket with(String key, float value) {
        this.checkHasPacket();
        if (!this.packet.getType(key).isValidForFloating()) {
            this.invalidType(key, "float");
        }
        this.data.put(key, Float.valueOf(value));
        return this;
    }

    public PendingPacket with(String key, double value) {
        this.checkHasPacket();
        if (!this.packet.getType(key).isValidForFloating()) {
            this.invalidType(key, "double");
        }
        this.data.put(key, value);
        return this;
    }

    public PendingPacket with(String key, String value) {
        this.checkHasPacket();
        if (!this.packet.getType(key).isValidForString()) {
            this.invalidType(key, "String");
        }
        if (value == null) {
            throw new IllegalArgumentException("Cannot use null for String value");
        }
        this.data.put(key, value);
        return this;
    }

    public PendingPacket with(String key, NBTTagCompound value) {
        this.checkHasPacket();
        if (!this.packet.getType(key).isValidForNBT()) {
            this.invalidType(key, "NBTTagCompound");
        }
        if (value == null) {
            throw new IllegalArgumentException("Cannot use null for NBTTagCompound value");
        }
        this.data.put(key, value);
        return this;
    }

    public PendingPacket with(String key, byte[] value) {
        this.checkHasPacket();
        if (!this.packet.getType(key).isValidForData()) {
            this.invalidType(key, "byte[]");
        }
        if (value == null) {
            throw new IllegalArgumentException("Cannot use null for byte[] value");
        }
        this.data.put(key, value);
        return this;
    }

    private void invalidType(String key, String type) {
        throw new IllegalArgumentException("Type " + type + " is not valid for '" + key + "' (data type " + (Object)((Object)this.packet.getType(key)) + ") in packet '" + this.packet.getIdentifier() + "'");
    }

    private void checkHasPacket() {
        if (this.packet == null) {
            throw new IllegalArgumentException("Must specify packet before data");
        }
    }

    public void to(EntityPlayer player) {
        if (this.packet.getSide().isServer()) {
            this.wrongSide();
        }
        if (player instanceof EntityPlayerMP) {
            for (Packet<INetHandlerPlayClient> p : this.toClientboundVanillaPackets()) {
                ((EntityPlayerMP)player).field_71135_a.func_147359_a(p);
            }
        }
    }

    public void toAllAround(World world, Entity entity, double radius) {
        this.toAllAround(world, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, radius);
    }

    public void toAllAround(World world, Vec3i pos, double radius) {
        this.toAllAround(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, radius);
    }

    public void toAllAround(World world, Vec3d pos, double radius) {
        this.toAllAround(world, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, radius);
    }

    public void toAllAround(World world, double x, double y, double z, double radius) {
        if (this.packet.getSide().isServer()) {
            this.wrongSide();
        }
        double sq = radius * radius;
        List<Packet<INetHandlerPlayClient>> packets = this.toClientboundVanillaPackets();
        for (EntityPlayerMP ep : world.func_175661_b(EntityPlayerMP.class, Predicates.alwaysTrue())) {
            if (!(ep.func_70092_e(x, y, z) <= sq)) continue;
            for (Packet<INetHandlerPlayClient> packet : packets) {
                ep.field_71135_a.func_147359_a(packet);
            }
        }
    }

    public void toAllWatching(World world, BlockPos pos) {
        if (this.packet.getSide().isServer()) {
            this.wrongSide();
        }
        if (world instanceof WorldServer) {
            WorldServer srv = (WorldServer)world;
            Chunk c = srv.func_175726_f(pos);
            if (srv.func_184164_w().func_152621_a(c.field_76635_g, c.field_76647_h)) {
                List<Packet<INetHandlerPlayClient>> packets = this.toClientboundVanillaPackets();
                for (EntityPlayerMP ep : world.func_175661_b(EntityPlayerMP.class, Predicates.alwaysTrue())) {
                    if (!srv.func_184164_w().func_72694_a(ep, c.field_76635_g, c.field_76647_h)) continue;
                    for (Packet<INetHandlerPlayClient> packet : packets) {
                        ep.field_71135_a.func_147359_a(packet);
                    }
                }
            }
        }
    }

    public void toAllWatching(TileEntity te) {
        this.toAllWatching(te.func_145831_w(), te.func_174877_v());
    }

    public void toAllWatching(Entity e) {
        if (this.packet.getSide().isServer()) {
            this.wrongSide();
        }
        if (e.field_70170_p instanceof WorldServer) {
            WorldServer srv = (WorldServer)e.field_70170_p;
            List<Packet<INetHandlerPlayClient>> packets = this.toClientboundVanillaPackets();
            for (Packet<INetHandlerPlayClient> packet : packets) {
                srv.func_73039_n().func_151247_a(e, packet);
            }
        }
    }

    public void toAllIn(World world) {
        if (this.packet.getSide().isServer()) {
            this.wrongSide();
        }
        List<Packet<INetHandlerPlayClient>> packets = this.toClientboundVanillaPackets();
        for (EntityPlayerMP ep : world.func_175661_b(EntityPlayerMP.class, Predicates.alwaysTrue())) {
            for (Packet<INetHandlerPlayClient> packet : packets) {
                ep.field_71135_a.func_147359_a(packet);
            }
        }
    }

    public void toEveryone() {
        if (this.packet.getSide().isServer()) {
            this.wrongSide();
        }
        List<Packet<INetHandlerPlayClient>> packets = this.toClientboundVanillaPackets();
        for (EntityPlayerMP ep : FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v()) {
            for (Packet<INetHandlerPlayClient> packet : packets) {
                ep.field_71135_a.func_147359_a(packet);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void toServer() {
        if (this.packet.getSide().isClient()) {
            this.wrongSide();
        }
        Minecraft.func_71410_x().func_147114_u().func_147297_a(this.toServerboundVanillaPacket());
    }

    private void wrongSide() {
        throw new IllegalStateException("Packet '" + this.packet.getIdentifier() + "' cannot be sent from side " + this.packet.getSide());
    }

    public Packet<INetHandlerPlayServer> toServerboundVanillaPacket() {
        return this.channel.getPacketFrom(this).toC17Packet();
    }

    public List<Packet<INetHandlerPlayClient>> toClientboundVanillaPackets() {
        try {
            return this.channel.getPacketFrom(this).toS3FPackets();
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

