/*
 * Decompiled with CFR 0.152.
 */
package io.github.elytra.davincisvessels.common.entity;

import io.github.elytra.davincisvessels.DavincisVesselsMod;
import io.github.elytra.davincisvessels.common.api.block.IBlockBalloon;
import io.github.elytra.davincisvessels.common.handler.ConnectionHandler;
import io.github.elytra.davincisvessels.common.object.DavincisVesselsObjects;
import io.github.elytra.davincisvessels.common.object.block.BlockHelm;
import io.github.elytra.davincisvessels.common.tileentity.AnchorInstance;
import io.github.elytra.davincisvessels.common.tileentity.TileAnchorPoint;
import io.github.elytra.davincisvessels.common.tileentity.TileEntitySecuredBed;
import io.github.elytra.davincisvessels.common.tileentity.TileHelm;
import io.github.elytra.movingworld.MovingWorldMod;
import io.github.elytra.movingworld.common.chunk.LocatedBlock;
import io.github.elytra.movingworld.common.chunk.MovingWorldAssemblyInteractor;
import io.github.elytra.movingworld.common.chunk.assembly.AssembleResult;
import io.github.elytra.movingworld.common.chunk.assembly.CanAssemble;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

public class ShipAssemblyInteractor
extends MovingWorldAssemblyInteractor {
    private int balloonCount;

    public void toByteBuf(ByteBuf byteBuf) {
        byteBuf.writeInt(this.getBalloonCount());
    }

    public MovingWorldAssemblyInteractor fromByteBuf(byte resultCode, ByteBuf buf) {
        if (resultCode == AssembleResult.ResultType.RESULT_NONE.toByte()) {
            return new ShipAssemblyInteractor();
        }
        int balloons = buf.readInt();
        ShipAssemblyInteractor assemblyInteractor = new ShipAssemblyInteractor();
        assemblyInteractor.setBalloonCount(balloons);
        return assemblyInteractor;
    }

    public MovingWorldAssemblyInteractor fromNBT(NBTTagCompound tag, World world) {
        ShipAssemblyInteractor mov = new ShipAssemblyInteractor();
        mov.setBalloonCount(tag.func_74762_e("balloonCount"));
        return mov;
    }

    public void blockAssembled(LocatedBlock locatedBlock) {
        Block block = locatedBlock.blockState.func_177230_c();
        if (block instanceof IBlockBalloon) {
            try {
                this.balloonCount += ((IBlockBalloon)block).getBalloonWorth(locatedBlock.tileEntity);
            }
            catch (NullPointerException e) {
                MovingWorldMod.LOG.error("IBlockBalloon didn't check if something was null or not, report to mod author of the following block, " + block.toString());
            }
        } else if (block == DavincisVesselsObjects.blockBalloon) {
            ++this.balloonCount;
        } else if (DavincisVesselsMod.INSTANCE.getNetworkConfig().isBalloon(block)) {
            ++this.balloonCount;
        }
    }

    public void blockDisassembled(LocatedBlock locatedBlock) {
        super.blockDisassembled(locatedBlock);
        if (locatedBlock.blockState.func_177230_c() == DavincisVesselsObjects.blockSecuredBed && locatedBlock.tileEntity != null && locatedBlock.tileEntity instanceof TileEntitySecuredBed) {
            TileEntitySecuredBed securedBed = (TileEntitySecuredBed)locatedBlock.tileEntity;
            securedBed.doMove = true;
            ConnectionHandler.playerBedMap.remove(securedBed.getPlayerID());
            securedBed.addToConnectionMap(securedBed.getPlayerID());
            securedBed.moveBed(locatedBlock.blockPos);
        }
    }

    public boolean isBlockMovingWorldMarker(Block block) {
        if (block != null) {
            return block.func_149739_a() == DavincisVesselsObjects.blockMarkShip.func_149739_a();
        }
        return false;
    }

    public boolean isTileMovingWorldMarker(TileEntity tile) {
        if (tile != null) {
            return tile instanceof TileHelm;
        }
        return false;
    }

    public CanAssemble isBlockAllowed(World world, LocatedBlock lb) {
        IBlockState state = lb.blockState;
        CanAssemble canAssemble = super.isBlockAllowed(world, lb);
        if (state.func_177230_c() == DavincisVesselsObjects.blockStickyBuffer || DavincisVesselsMod.INSTANCE.getNetworkConfig().isSticky(state.func_177230_c())) {
            canAssemble.assembleThenCancel = true;
        }
        if (lb.tileEntity != null && lb.tileEntity instanceof TileAnchorPoint && ((TileAnchorPoint)lb.tileEntity).getInstance().getType() == AnchorInstance.InstanceType.FORLAND) {
            canAssemble.justCancel = true;
        }
        return canAssemble;
    }

    public EnumFacing getFrontDirection(LocatedBlock marker) {
        return ((EnumFacing)marker.blockState.func_177229_b((IProperty)BlockHelm.field_176387_N)).func_176734_d();
    }

    public int getBalloonCount() {
        return this.balloonCount;
    }

    public void setBalloonCount(int balloonCount) {
        this.balloonCount = balloonCount;
    }

    public void writeNBTFully(NBTTagCompound tag) {
        this.writeNBTMetadata(tag);
    }

    public void writeNBTMetadata(NBTTagCompound tag) {
        tag.func_74768_a("balloonCount", this.getBalloonCount());
    }
}

