/*
 * Decompiled with CFR 0.152.
 */
package io.github.elytra.davincisvessels.common.handler;

import io.github.elytra.davincisvessels.DavincisVesselsMod;
import io.github.elytra.davincisvessels.common.entity.EntityParachute;
import io.github.elytra.davincisvessels.common.entity.EntitySeat;
import io.github.elytra.davincisvessels.common.entity.EntityShip;
import io.github.elytra.davincisvessels.common.network.DavincisVesselsNetworking;
import io.github.elytra.davincisvessels.common.tileentity.TileEntitySecuredBed;
import io.github.elytra.movingworld.common.util.Vec3dMod;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

public class ConnectionHandler {
    public static HashMap<UUID, TileEntitySecuredBed> playerBedMap = new HashMap();

    @SubscribeEvent
    public void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        if (event.isCanceled()) {
            return;
        }
        if (event.player != null && event.player.field_70170_p != null && !event.player.field_70170_p.field_72995_K) {
            this.handleParachuteLogout(event);
            this.handleConfigDesync(event);
            if (event.player.func_184187_bx() != null && event.player.func_184187_bx() instanceof EntityShip && !event.player.field_70170_p.func_73046_m().func_71264_H()) {
                ((EntityShip)event.player.func_184187_bx()).disassemble(true);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.isCanceled()) {
            return;
        }
        if (event.player != null && event.player.field_70170_p != null && !event.player.field_70170_p.field_72995_K) {
            this.handleParachuteLogin(event);
            this.handleBedLogin(event);
            this.handlerConfigSync(event);
        }
    }

    private void handlerConfigSync(PlayerEvent.PlayerLoggedInEvent event) {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            NBTTagCompound tagCompound = DavincisVesselsMod.INSTANCE.getLocalConfig().getShared().serialize();
            tagCompound.func_74757_a("restore", false);
            DavincisVesselsNetworking.NETWORK.send().packet("ConfigMessage").with("data", tagCompound).to(event.player);
        }
    }

    private void handleConfigDesync(PlayerEvent.PlayerLoggedOutEvent event) {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            // empty if block
        }
    }

    private void handleBedLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (playerBedMap.containsKey(event.player.func_146103_bH().getId())) {
            TileEntitySecuredBed bed = playerBedMap.get(event.player.func_146103_bH().getId());
            bed.setPlayer(event.player);
            bed.moveBed(bed.func_174877_v());
        }
    }

    private void handleParachuteLogin(PlayerEvent.PlayerLoggedInEvent event) {
        EntityPlayer player = event.player;
        World worldObj = player.field_70170_p;
        if (player.getEntityData().func_74767_n("reqParachute")) {
            NBTTagCompound nbt = player.getEntityData().func_74775_l("parachuteInfo");
            double vecX = nbt.func_74769_h("vecX");
            double vecY = nbt.func_74769_h("vecY");
            double vecZ = nbt.func_74769_h("vecZ");
            double shipX = nbt.func_74769_h("shipX");
            double shipY = nbt.func_74769_h("shipY");
            double shipZ = nbt.func_74769_h("shipZ");
            double motionX = nbt.func_74769_h("motionX");
            double motionY = nbt.func_74769_h("motionY");
            double motionZ = nbt.func_74769_h("motionZ");
            Vec3dMod vec = new Vec3dMod(vecX, vecY, vecZ);
            Vec3dMod shipVec = new Vec3dMod(shipX, shipY, shipZ);
            Vec3dMod motionVec = new Vec3dMod(motionX, motionY, motionZ);
            EntityParachute parachute = new EntityParachute(worldObj, (Entity)player, vec, shipVec, motionVec);
            worldObj.func_72838_d((Entity)parachute);
            player.getEntityData().func_82580_o("parachuteInfo");
            player.getEntityData().func_74757_a("reqParachute", false);
        }
    }

    private void handleParachuteLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        if (event.player.func_184187_bx() != null && event.player.func_184187_bx() instanceof EntitySeat) {
            EntityPlayer player = event.player;
            EntitySeat seat = (EntitySeat)player.func_184187_bx();
            EntityShip ship = seat.getShip();
            player.func_184210_p();
            if (ship != null && seat.getChunkPos() != null) {
                NBTTagCompound nbt = new NBTTagCompound();
                Vec3dMod vec = new Vec3dMod((double)((float)seat.getChunkPos().func_177958_n() - ship.getMobileChunk().getCenterX()), (double)(seat.getChunkPos().func_177956_o() - ship.getMobileChunk().minY()), (double)((float)seat.getChunkPos().func_177952_p() - ship.getMobileChunk().getCenterZ()));
                vec = vec.rotateAroundY((float)Math.toRadians(ship.field_70177_z));
                nbt.func_74780_a("vecX", vec.field_72450_a);
                nbt.func_74780_a("vecY", vec.field_72448_b);
                nbt.func_74780_a("vecZ", vec.field_72449_c);
                nbt.func_74780_a("shipX", ship.field_70165_t);
                nbt.func_74780_a("shipY", ship.field_70163_u);
                nbt.func_74780_a("shipZ", ship.field_70161_v);
                nbt.func_74780_a("motionX", ship.field_70159_w);
                nbt.func_74780_a("motionY", ship.field_70181_x);
                nbt.func_74780_a("motionZ", ship.field_70179_y);
                player.getEntityData().func_74782_a("parachuteInfo", (NBTBase)nbt);
                player.getEntityData().func_74757_a("reqParachute", true);
            }
        }
    }
}

