/*
 * Decompiled with CFR 0.152.
 */
package io.github.elytra.davincisvessels.common.network;

import io.github.elytra.davincisvessels.DavincisVesselsMod;
import io.github.elytra.davincisvessels.client.ClientProxy;
import io.github.elytra.davincisvessels.client.gui.ContainerHelm;
import io.github.elytra.davincisvessels.common.DavincisVesselsConfig;
import io.github.elytra.davincisvessels.common.entity.EntityShip;
import io.github.elytra.davincisvessels.common.entity.ShipAssemblyInteractor;
import io.github.elytra.davincisvessels.common.network.HelmClientAction;
import io.github.elytra.davincisvessels.common.object.DavincisVesselsObjects;
import io.github.elytra.davincisvessels.common.tileentity.AnchorInstance;
import io.github.elytra.davincisvessels.common.tileentity.BlockLocation;
import io.github.elytra.davincisvessels.common.tileentity.TileAnchorPoint;
import io.github.elytra.davincisvessels.common.tileentity.TileHelm;
import io.github.elytra.movingworld.common.chunk.assembly.AssembleResult;
import io.github.elytra.movingworld.repackage.com.unascribed.lambdanetwork.BiConsumer;
import io.github.elytra.movingworld.repackage.com.unascribed.lambdanetwork.DataType;
import io.github.elytra.movingworld.repackage.com.unascribed.lambdanetwork.LambdaNetwork;
import io.github.elytra.movingworld.repackage.com.unascribed.lambdanetwork.LambdaNetworkBuilder;
import io.github.elytra.movingworld.repackage.com.unascribed.lambdanetwork.Token;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.stats.StatBase;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.relauncher.Side;

public class DavincisVesselsNetworking {
    public static LambdaNetwork NETWORK;

    public static void setupNetwork() {
        DavincisVesselsMod.LOG.info("Setting up network...");
        NETWORK = DavincisVesselsNetworking.registerPackets(LambdaNetwork.builder().channel("ArchimedesShipsPlus")).build();
        DavincisVesselsMod.LOG.info("Setup network! " + NETWORK.toString());
    }

    private static LambdaNetworkBuilder registerPackets(LambdaNetworkBuilder builder) {
        builder = builder.packet("AssembleResultMessage").boundTo(Side.CLIENT).with(DataType.ARBITRARY, "result").handledBy(new BiConsumer<EntityPlayer, Token>(){

            @Override
            public void accept(EntityPlayer entityPlayer, Token token) {
                ByteBuf buf = Unpooled.wrappedBuffer((byte[])token.getData("result"));
                boolean prevFlag = buf.readBoolean();
                byte resultCode = buf.readByte();
                AssembleResult result = new AssembleResult(AssembleResult.ResultType.fromByte((byte)resultCode), buf);
                result.assemblyInteractor = new ShipAssemblyInteractor().fromByteBuf(resultCode, buf);
                if (entityPlayer != null && entityPlayer.field_71070_bA instanceof ContainerHelm) {
                    if (prevFlag) {
                        ((ContainerHelm)entityPlayer.field_71070_bA).tileEntity.setPrevAssembleResult(result);
                        ((ContainerHelm)entityPlayer.field_71070_bA).tileEntity.getPrevAssembleResult().assemblyInteractor = result.assemblyInteractor;
                    } else {
                        ((ContainerHelm)entityPlayer.field_71070_bA).tileEntity.setAssembleResult(result);
                        ((ContainerHelm)entityPlayer.field_71070_bA).tileEntity.getAssembleResult().assemblyInteractor = result.assemblyInteractor;
                    }
                }
            }
        });
        builder = builder.packet("ClientRequestSubmerseMessage").boundTo(Side.SERVER).with(DataType.INT, "dimID").with(DataType.INT, "entityID").with(DataType.BOOLEAN, "submerse").handledOnMainThreadBy(new BiConsumer<EntityPlayer, Token>(){

            @Override
            public void accept(EntityPlayer entityPlayer, Token token) {
                Entity unCast;
                boolean submerse = token.getBoolean("submerse");
                WorldServer world = DimensionManager.getWorld((int)token.getInt("dimID"));
                if (world != null && (unCast = world.func_73045_a(token.getInt("entityID"))) != null && unCast instanceof EntityShip) {
                    EntityShip ship = (EntityShip)unCast;
                    if (submerse && !ship.canSubmerge()) {
                        if (entityPlayer != null && entityPlayer instanceof EntityPlayerMP) {
                            ((EntityPlayerMP)entityPlayer).field_71135_a.func_147360_c("Oi, stop hacking ya moron.  \n XOXO ~Archimedes");
                        }
                        return;
                    }
                    ship.setSubmerge(submerse);
                    entityPlayer.func_71029_a((StatBase)DavincisVesselsObjects.achievementSubmerseShip);
                }
            }
        });
        builder = builder.packet("ClientHelmActionMessage").boundTo(Side.SERVER).with(DataType.INT, "action").with(DataType.INT, "tileX").with(DataType.INT, "tileY").with(DataType.INT, "tileZ").handledOnMainThreadBy(new BiConsumer<EntityPlayer, Token>(){

            @Override
            public void accept(EntityPlayer entityPlayer, Token token) {
                BlockPos pos = new BlockPos(token.getInt("tileX"), token.getInt("tileY"), token.getInt("tileZ"));
                HelmClientAction action = HelmClientAction.fromInt((byte)token.getInt("action"));
                if (entityPlayer.field_70170_p.func_175625_s(pos) != null && entityPlayer.field_70170_p.func_175625_s(pos) instanceof TileHelm) {
                    TileHelm tileEntity = (TileHelm)entityPlayer.field_70170_p.func_175625_s(pos);
                    switch (action) {
                        case ASSEMBLE: {
                            tileEntity.assembleMovingWorld(entityPlayer);
                            break;
                        }
                        case MOUNT: {
                            tileEntity.mountMovingWorld(entityPlayer, tileEntity.getMovingWorld(tileEntity.func_145831_w()));
                            break;
                        }
                        case UNDOCOMPILE: {
                            tileEntity.undoCompilation(entityPlayer);
                            break;
                        }
                    }
                }
            }
        });
        builder = builder.packet("ClientRenameShipMessage").boundTo(Side.SERVER).with(DataType.STRING, "newName").with(DataType.INT, "tileX").with(DataType.INT, "tileY").with(DataType.INT, "tileZ").handledOnMainThreadBy(new BiConsumer<EntityPlayer, Token>(){

            @Override
            public void accept(EntityPlayer entityPlayer, Token token) {
                BlockPos pos = new BlockPos(token.getInt("tileX"), token.getInt("tileY"), token.getInt("tileZ"));
                if (entityPlayer.field_70170_p.func_175625_s(pos) != null && entityPlayer.field_70170_p.func_175625_s(pos) instanceof TileHelm) {
                    TileHelm helm = (TileHelm)entityPlayer.field_70170_p.func_175625_s(pos);
                    helm.getInfo().setName(token.getString("newName"));
                }
            }
        });
        builder = builder.packet("ClientOpenGUIMessage").boundTo(Side.SERVER).with(DataType.INT, "guiID").handledOnMainThreadBy(new BiConsumer<EntityPlayer, Token>(){

            @Override
            public void accept(EntityPlayer entityPlayer, Token token) {
                entityPlayer.openGui((Object)DavincisVesselsMod.INSTANCE, token.getInt("guiID"), entityPlayer.field_70170_p, 0, 0, 0);
            }
        });
        builder = builder.packet("ClientAnchorPointActionMessage").boundTo(Side.SERVER).with(DataType.BYTE, "actionID").with(DataType.INT, "tileX").with(DataType.INT, "tileY").with(DataType.INT, "tileZ").handledOnMainThreadBy(new BiConsumer<EntityPlayer, Token>(){

            @Override
            public void accept(EntityPlayer entityPlayer, Token token) {
                World world = entityPlayer.field_70170_p;
                BlockPos anchorPos = new BlockPos(token.getInt("tileX"), token.getInt("tileY"), token.getInt("tileZ"));
                if (world == null || world.func_175625_s(anchorPos) == null || !(world.func_175625_s(anchorPos) instanceof TileAnchorPoint)) {
                    return;
                }
                TileAnchorPoint anchorPoint = (TileAnchorPoint)world.func_175625_s(anchorPos);
                if (token.getInt("actionID") == 0) {
                    for (Map.Entry<UUID, BlockLocation> e : anchorPoint.getInstance().getRelatedAnchors().entrySet()) {
                        if (world.func_175625_s(e.getValue().pos) != null && world.func_175625_s(e.getValue().pos) instanceof TileAnchorPoint) {
                            TileAnchorPoint entryAnchorPoint = (TileAnchorPoint)world.func_175625_s(e.getValue().pos);
                            ((EntityPlayerMP)entityPlayer).field_71135_a.func_147359_a((Packet)entryAnchorPoint.func_189518_D_());
                            continue;
                        }
                        DavincisVesselsMod.LOG.error("Invalid entries in anchor tile: " + anchorPoint.toString() + ", cleaning.");
                    }
                    anchorPoint.getInstance().clearRelations();
                    anchorPoint.getInstance().setType(anchorPoint.getInstance().getType().opposite());
                    anchorPoint.getInstance().setIdentifier(UUID.randomUUID());
                    anchorPoint.func_70296_d();
                } else if (anchorPoint.content != null) {
                    if (anchorPoint.getInstance().getType() == AnchorInstance.InstanceType.FORLAND) {
                        if (anchorPoint.content.func_77978_p() == null) {
                            anchorPoint.content.func_77982_d(new NBTTagCompound());
                        }
                        if (anchorPoint.content.func_77978_p().func_74764_b("INSTANCE")) {
                            anchorPoint.content.func_77978_p().func_82580_o("INSTANCE");
                        }
                        AnchorInstance itemAnchorInstanceTag = new AnchorInstance();
                        itemAnchorInstanceTag.setType(AnchorInstance.InstanceType.FORSHIP);
                        itemAnchorInstanceTag.setIdentifier(UUID.randomUUID());
                        itemAnchorInstanceTag.addRelation(anchorPoint.getInstance().getIdentifier(), new BlockLocation(anchorPos, entityPlayer.field_70170_p.field_73011_w.getDimension()));
                        anchorPoint.content.func_77978_p().func_74782_a("INSTANCE", (NBTBase)itemAnchorInstanceTag.serializeNBT());
                    } else {
                        if (anchorPoint.content.func_77978_p() == null) {
                            anchorPoint.content.func_77982_d(new NBTTagCompound());
                        }
                        if (anchorPoint.content.func_77978_p().func_74764_b("INSTANCE")) {
                            anchorPoint.content.func_77978_p().func_82580_o("INSTANCE");
                        }
                        AnchorInstance itemAnchorInstanceTag = new AnchorInstance();
                        itemAnchorInstanceTag.setType(AnchorInstance.InstanceType.FORLAND);
                        itemAnchorInstanceTag.setIdentifier(UUID.randomUUID());
                        itemAnchorInstanceTag.addRelation(anchorPoint.getInstance().getIdentifier(), new BlockLocation(anchorPos, entityPlayer.field_70170_p.field_73011_w.getDimension()));
                        anchorPoint.content.func_77978_p().func_74782_a("INSTANCE", (NBTBase)itemAnchorInstanceTag.serializeNBT());
                    }
                }
                anchorPoint.func_70296_d();
                if (world instanceof WorldServer) {
                    ((WorldServer)world).func_184164_w().func_180244_a(anchorPoint.func_174877_v());
                }
            }
        });
        builder = builder.packet("ControlInputMessage").boundTo(Side.SERVER).with(DataType.INT, "dimID").with(DataType.INT, "entityID").with(DataType.BYTE, "control").handledOnMainThreadBy(new BiConsumer<EntityPlayer, Token>(){

            @Override
            public void accept(EntityPlayer entityPlayer, Token token) {
                Entity unCast;
                WorldServer world = DimensionManager.getWorld((int)token.getInt("dimID"));
                if (world != null && (unCast = world.func_73045_a(token.getInt("entityID"))) != null && unCast instanceof EntityShip) {
                    EntityShip ship = (EntityShip)unCast;
                    ship.getController().updateControl(ship, entityPlayer, token.getInt("control"));
                }
            }
        });
        builder = builder.packet("TranslatedChatMessage").boundTo(Side.CLIENT).with(DataType.STRING, "message").handledOnMainThreadBy(new BiConsumer<EntityPlayer, Token>(){

            @Override
            public void accept(EntityPlayer entityPlayer, Token token) {
                if (entityPlayer == null) {
                    return;
                }
                String message = token.getString("message");
                String[] split = message.split("~");
                TextComponentString text = new TextComponentString("");
                if (split.length > 0) {
                    for (String string : split) {
                        if (string.startsWith("TR:")) {
                            text.func_150257_a((ITextComponent)new TextComponentTranslation(string.substring(3), new Object[0]));
                            continue;
                        }
                        text.func_150257_a((ITextComponent)new TextComponentString(string));
                    }
                }
                entityPlayer.func_146105_b((ITextComponent)text);
            }
        });
        builder = builder.packet("ConfigMessage").boundTo(Side.CLIENT).with(DataType.NBT_COMPOUND, "data").handledOnMainThreadBy(new BiConsumer<EntityPlayer, Token>(){

            @Override
            public void accept(EntityPlayer entityPlayer, Token token) {
                NBTTagCompound tag = token.getNBT("data");
                DavincisVesselsConfig.SharedConfig config = null;
                if (!tag.func_74767_n("restore")) {
                    config = DavincisVesselsMod.INSTANCE.getLocalConfig().getShared().deserialize(tag);
                }
                if (DavincisVesselsMod.PROXY != null && DavincisVesselsMod.PROXY instanceof ClientProxy) {
                    if (config != null) {
                        ((ClientProxy)DavincisVesselsMod.PROXY).syncedConfig = DavincisVesselsMod.INSTANCE.getLocalConfig();
                        ((ClientProxy)DavincisVesselsMod.PROXY).syncedConfig.setShared(config);
                    } else {
                        ((ClientProxy)DavincisVesselsMod.PROXY).syncedConfig = null;
                    }
                }
            }
        });
        return builder;
    }
}

