/*
 * Decompiled with CFR 0.152.
 */
package io.github.elytra.movingworld.repackage.com.unascribed.lambdanetwork;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import io.github.elytra.movingworld.repackage.com.unascribed.lambdanetwork.DataType;
import io.github.elytra.movingworld.repackage.com.unascribed.lambdanetwork.PacketSpec;
import io.github.elytra.movingworld.repackage.com.unascribed.lambdanetwork.PendingPacket;
import io.github.elytra.movingworld.repackage.com.unascribed.lambdanetwork.Token;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LambdaChannel {
    private final String channel;
    private final ImmutableMap<String, PacketSpec> packets;
    private final ImmutableList<String> ids;

    public LambdaChannel(String channel, List<PacketSpec> packets) {
        this.channel = channel;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        ImmutableList.Builder ids = ImmutableList.builder();
        for (PacketSpec ps : packets) {
            builder.put((Object)ps.getIdentifier(), (Object)PacketSpec.immutableClone(ps));
            ids.add((Object)ps.getIdentifier());
        }
        this.packets = builder.build();
        this.ids = ids.build();
        NetworkRegistry.INSTANCE.newEventDrivenChannel(channel).register((Object)this);
    }

    public PacketSpec getPacketSpec(String packet) {
        if (!this.packets.containsKey((Object)packet)) {
            throw new IllegalArgumentException("No such packet '" + packet + "' on channel '" + this.channel + "'");
        }
        return (PacketSpec)this.packets.get((Object)packet);
    }

    public FMLProxyPacket getPacketFrom(PendingPacket pp) {
        if (pp.getData().size() != pp.getPacket().getData().size()) {
            throw new IllegalArgumentException("Missing data for keys " + Lists.newArrayList(pp.getPacket().getData().keySet()).removeAll(pp.getData().keySet()));
        }
        PacketSpec spec = pp.getPacket();
        PacketBuffer payload = new PacketBuffer(Unpooled.buffer((int)spec.getMinimumSize()));
        payload.writeByte(this.ids.indexOf((Object)spec.getIdentifier()));
        int booleanBits = spec.getAmountOfType(DataType.BOOLEAN);
        int i = 0;
        while ((double)i < Math.ceil((float)booleanBits / 8.0f)) {
            int by = 0;
            for (int j = i * 8; j < Math.min(spec.getBooleanKeys().size(), i + 8); ++j) {
                String key = spec.getBooleanKeys().get(j);
                if (!((Boolean)pp.getData().get(key)).booleanValue()) continue;
                by |= 1 << j;
            }
            payload.writeByte(by);
            ++i;
        }
        for (Map.Entry<String, DataType> en : spec.getData().entrySet()) {
            if (en.getValue().writer == null) continue;
            en.getValue().writer.accept((ByteBuf)payload, pp.getData().get(en.getKey()));
        }
        return new FMLProxyPacket(payload, this.channel);
    }

    @SubscribeEvent
    public void onServerCustomPacket(FMLNetworkEvent.ServerCustomPacketEvent e) {
        ByteBuf payload = e.getPacket().payload();
        this.readPacket(e.side(), (EntityPlayer)((NetHandlerPlayServer)e.getHandler()).field_147369_b, payload);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onClientCustomPacket(FMLNetworkEvent.ClientCustomPacketEvent e) {
        ByteBuf payload = e.getPacket().payload();
        this.readPacket(e.side(), (EntityPlayer)Minecraft.func_71410_x().field_71439_g, payload);
    }

    private void readPacket(Side side, EntityPlayer p, ByteBuf payload) {
        short id = payload.readUnsignedByte();
        if (id >= this.ids.size()) {
            throw new IllegalArgumentException("Unknown lambda packet id " + id);
        }
        String strId = (String)this.ids.get((int)id);
        PacketSpec spec = (PacketSpec)this.packets.get((Object)strId);
        if (spec.getSide() != side) {
            throw new IllegalArgumentException("Packet '" + spec.getIdentifier() + "' is not valid for side " + side);
        }
        Token token = new Token(spec);
        int booleanBits = spec.getAmountOfType(DataType.BOOLEAN);
        int i = 0;
        while ((double)i < Math.ceil((float)booleanBits / 8.0f)) {
            short by = payload.readUnsignedByte();
            for (int j = i * 8; j < Math.min(spec.getBooleanKeys().size(), i + 8); ++j) {
                token.putData(spec.getBooleanKeys().get(j), (by & 1 << j - i) != 0);
            }
            ++i;
        }
        for (Map.Entry<String, DataType> en : spec.getData().entrySet()) {
            if (en.getValue().reader == null) continue;
            token.putData(en.getKey(), en.getValue().reader.apply(payload));
        }
        spec.getConsumer().accept(p, token);
    }
}

