/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.davincisvessels.common.object.block;

import com.elytradev.davincisvessels.common.tileentity.TileCrate;
import com.elytradev.movingworld.common.entity.EntityMovingWorld;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockFence;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockCrate
extends BlockContainer {
    public static final PropertyEnum AXIS = PropertyEnum.func_177706_a((String)"axis", EnumFacing.Axis.class, (Enum[])new EnumFacing.Axis[]{EnumFacing.Axis.X, EnumFacing.Axis.Z});
    public static final PropertyBool POWERED = PropertyBool.func_177716_a((String)"powered");

    public BlockCrate(Material material) {
        super(material);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)AXIS, (Comparable)EnumFacing.Axis.X).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public static int getMetaForAxis(EnumFacing.Axis axis) {
        return axis == EnumFacing.Axis.X ? 1 : (axis == EnumFacing.Axis.Z ? 2 : 0);
    }

    public AxisAlignedBB getCollisionBoundingBox(IBlockState blockState, World worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, (double)0.1f, 1.0);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.SOLID;
    }

    public IBlockState func_176203_a(int meta) {
        boolean powered = false;
        if (meta > 2) {
            powered = true;
            meta /= 2;
        }
        return this.func_176223_P().func_177226_a((IProperty)AXIS, (Comparable)((meta & 3) == 2 ? EnumFacing.Axis.Z : EnumFacing.Axis.X)).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(powered));
    }

    public int func_176201_c(IBlockState state) {
        return BlockCrate.getMetaForAxis((EnumFacing.Axis)state.func_177229_b((IProperty)AXIS)) * ((Boolean)state.func_177229_b((IProperty)POWERED) != false ? 2 : 1);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AXIS, POWERED});
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)AXIS, (Comparable)placer.func_174811_aO().func_176740_k());
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)AXIS, (Comparable)placer.func_174811_aO().func_176740_k()), 2);
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        TileEntity te;
        if (world.field_72995_K || ((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) {
            return;
        }
        if (entity != null && !(entity instanceof EntityPlayer) && !(entity instanceof EntityMovingWorld) && (te = world.func_175625_s(pos)) != null && te instanceof TileCrate && ((TileCrate)te).canCatchEntity() && ((TileCrate)te).getContainedEntity() == null) {
            ((TileCrate)te).setContainedEntity(entity);
        }
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileCrate();
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof TileCrate) {
            ((TileCrate)te).releaseEntity();
            return true;
        }
        return false;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return this.canBePlacedOn(worldIn, pos.func_177977_b());
    }

    private boolean canBePlacedOn(World worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos).isSideSolid((IBlockAccess)worldIn, pos, EnumFacing.UP) || worldIn.func_180495_p(pos).func_177230_c() instanceof BlockFence;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        boolean powered;
        if (worldIn.field_72995_K) {
            return;
        }
        if (!this.canBePlacedOn(worldIn, pos.func_177977_b())) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
        }
        boolean bl = powered = worldIn.func_175640_z(pos) || worldIn.func_175640_z(pos.func_177984_a());
        if (powered) {
            TileEntity te = worldIn.func_175625_s(pos);
            if (te != null && te instanceof TileCrate) {
                ((TileCrate)te).releaseEntity();
                worldIn.func_175656_a(pos, worldIn.func_180495_p(pos).func_177226_a((IProperty)POWERED, (Comparable)Boolean.TRUE));
            }
        } else {
            worldIn.func_175656_a(pos, worldIn.func_180495_p(pos).func_177226_a((IProperty)POWERED, (Comparable)Boolean.FALSE));
        }
    }
}

