/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.movingworld.common.chunk.assembly;

import com.elytradev.movingworld.MovingWorldMod;
import com.elytradev.movingworld.common.chunk.LocatedBlock;
import com.elytradev.movingworld.common.chunk.MovingWorldAssemblyInteractor;
import com.elytradev.movingworld.common.chunk.MovingWorldSizeOverflowException;
import com.elytradev.movingworld.common.chunk.assembly.AssembleResult;
import com.elytradev.movingworld.common.chunk.assembly.CanAssemble;
import com.elytradev.movingworld.common.event.AssembleBlockEvent;
import java.util.ArrayList;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class ChunkAssembler {
    public final BlockPos start;
    private final int maxBlocks;
    private World worldObj;

    public ChunkAssembler(World world, BlockPos startPos, int maxMovingWorldBlocks) {
        this.worldObj = world;
        this.start = startPos;
        this.maxBlocks = maxMovingWorldBlocks;
    }

    public AssembleResult doAssemble(MovingWorldAssemblyInteractor interactor) {
        AssembleResult result = new AssembleResult();
        result.offset = this.start;
        result.assemblyInteractor = interactor;
        try {
            if (MovingWorldMod.INSTANCE.getNetworkConfig().getShared().iterativeAlgorithm) {
                this.assembleIterative(result, result.assemblyInteractor, this.start);
            } else {
                this.assembleRecursive(result, new HashSet<BlockPos>(), result.assemblyInteractor, this.start);
            }
            result.resultType = result.movingWorldMarkingBlock == null ? AssembleResult.ResultType.RESULT_MISSING_MARKER : AssembleResult.ResultType.RESULT_OK;
        }
        catch (MovingWorldSizeOverflowException e) {
            result.resultType = AssembleResult.ResultType.RESULT_BLOCK_OVERFLOW;
        }
        catch (Error e) {
            result.resultType = AssembleResult.ResultType.RESULT_ERROR_OCCURED;
            MovingWorldMod.LOG.error(e.toString());
        }
        result.assemblyInteractor.chunkAssembled(result);
        return result;
    }

    private void assembleIterative(AssembleResult result, MovingWorldAssemblyInteractor assemblyInteractor, BlockPos worldPos) throws MovingWorldSizeOverflowException {
        HashSet<BlockPos> openSet = new HashSet<BlockPos>();
        HashSet<BlockPos> closedSet = new HashSet<BlockPos>();
        ArrayList<BlockPos> iterator = new ArrayList<BlockPos>();
        LocatedBlock movingWorldMarker = null;
        openSet.add(new BlockPos((Vec3i)worldPos));
        while (!openSet.isEmpty()) {
            iterator.addAll(openSet);
            for (BlockPos mobileChunkPos : iterator) {
                openSet.remove(mobileChunkPos);
                if (closedSet.contains(mobileChunkPos)) continue;
                if (result.assembledBlocks.size() > this.maxBlocks) {
                    throw new MovingWorldSizeOverflowException();
                }
                worldPos = new BlockPos((Vec3i)mobileChunkPos);
                closedSet.add(mobileChunkPos);
                IBlockState blockState = this.worldObj.func_180495_p(worldPos);
                CanAssemble canAssemble = this.canUseBlockForVehicle(new LocatedBlock(blockState, this.worldObj.func_175625_s(worldPos), worldPos), assemblyInteractor);
                if (canAssemble.justCancel) continue;
                LocatedBlock lb = new LocatedBlock(blockState, this.worldObj.func_175625_s(worldPos), mobileChunkPos);
                assemblyInteractor.blockAssembled(lb);
                if ((assemblyInteractor.isTileMovingWorldMarker(lb.tileEntity) || assemblyInteractor.isBlockMovingWorldMarker(lb.blockState.func_177230_c())) && movingWorldMarker == null) {
                    movingWorldMarker = lb;
                }
                AssembleBlockEvent event = new AssembleBlockEvent(lb);
                MinecraftForge.EVENT_BUS.post((Event)event);
                result.assembleBlock(lb);
                if (canAssemble.assembleThenCancel) continue;
                openSet.add(worldPos.func_177982_a(-1, 0, 0));
                openSet.add(worldPos.func_177982_a(0, -1, 0));
                openSet.add(worldPos.func_177982_a(0, 0, -1));
                openSet.add(worldPos.func_177982_a(1, 0, 0));
                openSet.add(worldPos.func_177982_a(0, 1, 0));
                openSet.add(worldPos.func_177982_a(0, 0, 1));
                if (!assemblyInteractor.doDiagonalAssembly()) continue;
                openSet.add(worldPos.func_177982_a(-1, -1, 0));
                openSet.add(worldPos.func_177982_a(1, -1, 0));
                openSet.add(worldPos.func_177982_a(1, 1, 0));
                openSet.add(worldPos.func_177982_a(-1, 1, 0));
                openSet.add(worldPos.func_177982_a(-1, 0, -1));
                openSet.add(worldPos.func_177982_a(1, 0, -1));
                openSet.add(worldPos.func_177982_a(1, 0, 1));
                openSet.add(worldPos.func_177982_a(-1, 0, 1));
                openSet.add(worldPos.func_177982_a(0, -1, -1));
                openSet.add(worldPos.func_177982_a(0, 1, -1));
                openSet.add(worldPos.func_177982_a(0, 1, 1));
                openSet.add(worldPos.func_177982_a(0, -1, 1));
            }
        }
        result.movingWorldMarkingBlock = movingWorldMarker;
    }

    private void assembleRecursive(AssembleResult result, HashSet<BlockPos> set, MovingWorldAssemblyInteractor assemblyInteractor, BlockPos pos) throws MovingWorldSizeOverflowException {
        LocatedBlock movingWorldMarker = null;
        if (result.assembledBlocks.size() > this.maxBlocks) {
            throw new MovingWorldSizeOverflowException();
        }
        if (set.contains(pos)) {
            return;
        }
        set.add(pos);
        IBlockState blockState = this.worldObj.func_180495_p(pos);
        Block block = blockState.func_177230_c();
        CanAssemble canAssemble = this.canUseBlockForVehicle(new LocatedBlock(blockState, this.worldObj.func_175625_s(pos), pos), assemblyInteractor);
        if (canAssemble.justCancel) {
            return;
        }
        LocatedBlock lb = new LocatedBlock(blockState, this.worldObj.func_175625_s(pos), pos);
        assemblyInteractor.blockAssembled(lb);
        if ((assemblyInteractor.isBlockMovingWorldMarker(block) || assemblyInteractor.isTileMovingWorldMarker(lb.tileEntity)) && movingWorldMarker == null) {
            movingWorldMarker = lb;
        }
        AssembleBlockEvent event = new AssembleBlockEvent(lb);
        MinecraftForge.EVENT_BUS.post((Event)event);
        result.assembleBlock(lb);
        if (!canAssemble.assembleThenCancel) {
            this.assembleRecursive(result, set, assemblyInteractor, pos.func_177982_a(-1, 0, 0));
            this.assembleRecursive(result, set, assemblyInteractor, pos.func_177982_a(0, -1, 0));
            this.assembleRecursive(result, set, assemblyInteractor, pos.func_177982_a(0, 0, -1));
            this.assembleRecursive(result, set, assemblyInteractor, pos.func_177982_a(1, 0, 0));
            this.assembleRecursive(result, set, assemblyInteractor, pos.func_177982_a(0, 1, 0));
            this.assembleRecursive(result, set, assemblyInteractor, pos.func_177982_a(0, 0, 1));
            if (assemblyInteractor.doDiagonalAssembly()) {
                this.assembleRecursive(result, set, assemblyInteractor, pos.func_177982_a(-1, -1, 0));
                this.assembleRecursive(result, set, assemblyInteractor, pos.func_177982_a(1, -1, 0));
                this.assembleRecursive(result, set, assemblyInteractor, pos.func_177982_a(1, 1, 0));
                this.assembleRecursive(result, set, assemblyInteractor, pos.func_177982_a(-1, 1, 0));
                this.assembleRecursive(result, set, assemblyInteractor, pos.func_177982_a(-1, 0, -1));
                this.assembleRecursive(result, set, assemblyInteractor, pos.func_177982_a(1, 0, -1));
                this.assembleRecursive(result, set, assemblyInteractor, pos.func_177982_a(1, 0, 1));
                this.assembleRecursive(result, set, assemblyInteractor, pos.func_177982_a(-1, 0, 1));
                this.assembleRecursive(result, set, assemblyInteractor, pos.func_177982_a(0, -1, -1));
                this.assembleRecursive(result, set, assemblyInteractor, pos.func_177982_a(0, 1, -1));
                this.assembleRecursive(result, set, assemblyInteractor, pos.func_177982_a(0, 1, 1));
                this.assembleRecursive(result, set, assemblyInteractor, pos.func_177982_a(0, -1, 1));
            }
        }
        result.movingWorldMarkingBlock = movingWorldMarker;
    }

    public CanAssemble canUseBlockForVehicle(LocatedBlock lb, MovingWorldAssemblyInteractor assemblyInteractor) {
        return assemblyInteractor.isBlockAllowed(this.worldObj, lb);
    }
}

