/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.movingworld.common.chunk.mobilechunk;

import com.elytradev.movingworld.client.render.MobileChunkRenderer;
import com.elytradev.movingworld.common.chunk.mobilechunk.MobileChunk;
import com.elytradev.movingworld.common.entity.EntityMovingWorld;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class MobileChunkClient
extends MobileChunk {
    public Map<BlockPos, TileEntity> fastTESRS = Maps.newHashMap();
    public Map<BlockPos, TileEntity> normalTESRS = Maps.newHashMap();
    private MobileChunkRenderer renderer = new MobileChunkRenderer(this);

    public MobileChunkClient(World world, EntityMovingWorld movingWorld) {
        super(world, movingWorld);
    }

    public MobileChunkRenderer getRenderer() {
        return this.renderer;
    }

    @Override
    public void onChunkUnload() {
        ArrayList iterator = new ArrayList(this.chunkTileEntityMap.values());
        for (TileEntity te : iterator) {
            this.removeChunkBlockTileEntity(te.func_174877_v());
        }
        super.onChunkUnload();
        this.renderer.markRemoved();
    }

    @Override
    public void setChunkModified() {
        super.setChunkModified();
        this.renderer.markDirty();
    }

    @Override
    public void setTileEntity(BlockPos pos, TileEntity tileentity) {
        super.setTileEntity(pos, tileentity);
        if (tileentity == null) {
            if (this.fastTESRS.containsKey(pos)) {
                this.fastTESRS.remove(pos);
            }
            if (this.normalTESRS.containsKey(pos)) {
                this.normalTESRS.remove(pos);
            }
        } else if (TileEntityRendererDispatcher.field_147556_a.func_147547_b(tileentity) != null) {
            if (tileentity.hasFastRenderer()) {
                this.fastTESRS.put(pos, tileentity);
            } else {
                this.normalTESRS.put(pos, tileentity);
            }
        }
    }

    @Override
    public Side side() {
        return Side.CLIENT;
    }
}

