/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.movingworld.common.network.message;

import com.elytradev.movingworld.common.chunk.mobilechunk.MobileChunkClient;
import com.elytradev.movingworld.common.entity.EntityMovingWorld;
import com.elytradev.movingworld.common.network.MovingWorldNetworking;
import com.elytradev.movingworld.repackage.com.elytradev.concrete.network.Message;
import com.elytradev.movingworld.repackage.com.elytradev.concrete.network.NetworkContext;
import com.elytradev.movingworld.repackage.com.elytradev.concrete.network.annotation.field.MarshalledAs;
import com.elytradev.movingworld.repackage.com.elytradev.concrete.network.annotation.type.ReceivedOn;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@ReceivedOn(value=Side.CLIENT)
public class MovingWorldTileChangeMessage
extends Message {
    @MarshalledAs(value="com.elytradev.movingworld.common.network.marshallers.EntityMarshaller")
    public EntityMovingWorld movingWorld;
    public NBTTagCompound tileData;

    public MovingWorldTileChangeMessage(NetworkContext ctx) {
        super(ctx);
    }

    public MovingWorldTileChangeMessage(EntityMovingWorld movingWorld, NBTTagCompound tileData) {
        super(MovingWorldNetworking.NETWORK);
        this.movingWorld = movingWorld;
        this.tileData = tileData;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void handle(EntityPlayer sender) {
        if (this.movingWorld == null || this.tileData == null || this.movingWorld.getMobileChunk() == null || !(this.movingWorld.getMobileChunk() instanceof MobileChunkClient)) {
            return;
        }
        NBTTagList list = this.tileData.func_150295_c("list", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound nbt = list.func_150305_b(i);
            if (nbt == null) continue;
            int x = nbt.func_74762_e("x");
            int y = nbt.func_74762_e("y");
            int z = nbt.func_74762_e("z");
            BlockPos pos = new BlockPos(x, y, z);
            try {
                TileEntity te = this.movingWorld.getMobileChunk().func_175625_s(pos);
                if (te == null) continue;
                te.func_145839_a(nbt);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        ((MobileChunkClient)this.movingWorld.getMobileChunk()).getRenderer().markDirty();
    }
}

