/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.davincisvessels.common;

import com.elytradev.davincisvessels.common.object.DavincisVesselsObjects;
import com.elytradev.movingworld.MovingWorldMod;
import com.google.gson.Gson;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.ArrayUtils;
import org.lwjgl.input.Keyboard;

public class DavincisVesselsConfig {
    public static final int CONTROL_TYPE_VANILLA = 0;
    public static final int CONTROL_TYPE_DAVINCI = 1;
    @SideOnly(value=Side.CLIENT)
    public KeyBinding kbUp;
    @SideOnly(value=Side.CLIENT)
    public KeyBinding kbDown;
    @SideOnly(value=Side.CLIENT)
    public KeyBinding kbBrake;
    @SideOnly(value=Side.CLIENT)
    public KeyBinding kbAlign;
    @SideOnly(value=Side.CLIENT)
    public KeyBinding kbDisassemble;
    @SideOnly(value=Side.CLIENT)
    public KeyBinding kbShipInv;
    public int anchorRadius;
    private Configuration config;
    private SharedConfig shared = new SharedConfig();

    public DavincisVesselsConfig(Configuration configuration) {
        this.config = configuration;
        this.shared.balloonAlternatives = new HashSet<String>();
        this.shared.seats = new HashSet<String>();
        this.shared.stickyObjects = new HashSet<String>();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void loadAndSave() {
        this.config.load();
        this.shared.shipEntitySyncRate = this.config.get("settings", "sync_rate", 5, "The amount of ticks between a server-client synchronization. Higher numbers reduce network traffic. Lower numbers increase multiplayer experience. 20 ticks = 1 second").getInt();
        this.shared.enableAirShips = this.config.get("settings", "enable_air_ships", true, "Enable or disable air ships.").getBoolean(true);
        this.shared.enableSubmersibles = this.config.get("settings", "enable_submersibles", true, "Enable or disable the ability to submerse ships.").getBoolean(true);
        this.shared.bankingMultiplier = (float)this.config.get("settings", "banking_multiplier", 3.0, "A multiplier for how much ships bank while making turns. Set a positive value for passive banking or a negative value for active banking. 0 disables banking.").getDouble(3.0);
        this.shared.enginesMandatory = this.config.get("settings", "mandatory_engines", false, "Are engines required for a ship to move?").getBoolean();
        this.shared.enableShipDownfall = this.config.get("settings", "ship_fall", true, "Do ships slowly fall?").getBoolean();
        this.anchorRadius = this.config.get("settings", "anchor_radius", 12, "The radius around the ship that an anchor can snap to.").getInt();
        this.shared.shipControlType = this.config.get("control", "control_type", 1, "Set to 0 to use vanilla boat controls, set to 1 to use Davinci controls.").getInt();
        this.shared.turnSpeed = (float)this.config.get("control", "turn_speed", 1.0, "A multiplier of the ship's turn speed.").getDouble(1.0);
        this.shared.speedLimit = (float)this.config.get("control", "speed_limit", 30.0, "The maximum velocity a ship can have, in OBJECTS per second. This does not affect acceleration.").getDouble(30.0);
        this.shared.speedLimit /= 20.0f;
        this.shared.disassembleOnDismount = this.config.get("control", "decompile_on_dismount", false).getBoolean(false);
        this.shared.maxShipChunkBlocks = this.config.get("mobile_chunk", "max_chunk_blocks", 2048, "The maximum amount of OBJECTS that a mobile ship chunk may contain.").getInt();
        this.shared.flyBalloonRatio = (float)this.config.get("mobile_chunk", "airship_balloon_ratio", 0.4, "The part of the total amount of OBJECTS that should be balloon OBJECTS in order to make an airship.").getDouble(0.4);
        this.shared.submersibleFillRatio = (float)this.config.get("mobile_chunk", "submersible_fill_ratio", 0.3, "The part of the ship that needs to not be water fillable for it to be considered submersible.").getDouble(0.9);
        if (FMLCommonHandler.instance().getSide().isClient()) {
            this.loadKeybindings();
        }
        this.config.save();
    }

    public void addBlacklistWhitelistEntries() {
        MovingWorldMod.INSTANCE.getNetworkConfig().addBlacklistedBlock(DavincisVesselsObjects.blockBuffer);
        MovingWorldMod.INSTANCE.getNetworkConfig().addWhitelistedBlock((Block)DavincisVesselsObjects.blockMarkShip);
        MovingWorldMod.INSTANCE.getNetworkConfig().addWhitelistedBlock(DavincisVesselsObjects.blockFloater);
        MovingWorldMod.INSTANCE.getNetworkConfig().addWhitelistedBlock(DavincisVesselsObjects.blockBalloon);
        MovingWorldMod.INSTANCE.getNetworkConfig().addWhitelistedBlock((Block)DavincisVesselsObjects.blockGauge);
        MovingWorldMod.INSTANCE.getNetworkConfig().addWhitelistedBlock((Block)DavincisVesselsObjects.blockSeat);
        MovingWorldMod.INSTANCE.getNetworkConfig().addWhitelistedBlock(DavincisVesselsObjects.blockEngine);
        MovingWorldMod.INSTANCE.getNetworkConfig().addWhitelistedBlock(DavincisVesselsObjects.blockStickyBuffer);
        MovingWorldMod.INSTANCE.getNetworkConfig().addWhitelistedBlock(DavincisVesselsObjects.blockAnchorPoint);
    }

    public void postLoad() {
        Block[] defaultStickyBlocks = new Block[]{DavincisVesselsObjects.blockStickyBuffer, Blocks.field_150430_aB, Blocks.field_150471_bO, Blocks.field_150442_at};
        String[] stickyBlockNames = new String[defaultStickyBlocks.length];
        for (int i = 0; i < defaultStickyBlocks.length; ++i) {
            stickyBlockNames[i] = ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)defaultStickyBlocks[i])).toString();
        }
        Block[] defaultSeatBlocks = new Block[]{DavincisVesselsObjects.blockSeat, Blocks.field_150378_br};
        String[] seatBlockNames = new String[defaultSeatBlocks.length];
        for (int i = 0; i < defaultSeatBlocks.length; ++i) {
            seatBlockNames[i] = ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)defaultSeatBlocks[i])).toString();
        }
        Block[] defaultBalloonBlocks = new Block[]{DavincisVesselsObjects.blockBalloon};
        String[] balloonBlockNames = new String[defaultBalloonBlocks.length];
        for (int i = 0; i < defaultBalloonBlocks.length; ++i) {
            balloonBlockNames[i] = ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)defaultBalloonBlocks[i])).toString();
        }
        this.config.load();
        String[] balloonBlocks = this.config.get("mobile_chunk", "balloon_blocks", balloonBlockNames, "A list of blocks that are taken into account for ship flight capability").getStringList();
        Collections.addAll(this.shared.balloonAlternatives, balloonBlocks);
        String[] seatBlocks = this.config.get("settings", "seats", seatBlockNames, "Blocks that are considered seats, BlockSeat is hard coded, you can't disable it.").getStringList();
        Collections.addAll(this.shared.seats, seatBlocks);
        String[] stickyBlocks = this.config.get("settings", "stickyblocks", stickyBlockNames, "Blocks that behave like a Sticky buffer, they stop assembly when they're reached").getStringList();
        Collections.addAll(this.shared.stickyObjects, stickyBlocks);
        this.config.save();
    }

    @SideOnly(value=Side.CLIENT)
    private void loadKeybindings() {
        this.kbUp = new KeyBinding("key.davincis.up", this.getKeyIndex(this.config, "key_ascent", 45), "Davincis Vessels");
        this.kbDown = new KeyBinding("key.davincis.down", this.getKeyIndex(this.config, "key_descent", 44), "Davincis Vessels");
        this.kbBrake = new KeyBinding("key.davincis.brake", this.getKeyIndex(this.config, "key_brake", 46), "Davincis Vessels");
        this.kbAlign = new KeyBinding("key.davincis.align", this.getKeyIndex(this.config, "key_align", 13), "Davincis Vessels");
        this.kbDisassemble = new KeyBinding("key.davincis.decompile", this.getKeyIndex(this.config, "key_decompile", 43), "Davincis Vessels");
        this.kbShipInv = new KeyBinding("key.davincis.shipinv", this.getKeyIndex(this.config, "key_shipinv", 37), "Davincis Vessels");
        Minecraft mc = Minecraft.func_71410_x();
        mc.field_71474_y.field_74324_K = (KeyBinding[])ArrayUtils.addAll((Object[])mc.field_71474_y.field_74324_K, (Object[])new KeyBinding[]{this.kbUp, this.kbDown, this.kbBrake, this.kbAlign, this.kbDisassemble, this.kbShipInv});
    }

    @SideOnly(value=Side.CLIENT)
    private int getKeyIndex(Configuration config, String name, int defaultkey) {
        return Keyboard.getKeyIndex((String)config.get("control", name, Keyboard.getKeyName((int)defaultkey)).getString());
    }

    public boolean isBalloon(Block block) {
        return this.shared.balloonAlternatives.contains(((ResourceLocation)Block.field_149771_c.func_177774_c((Object)block)).toString());
    }

    public boolean isSeat(Block block) {
        return this.shared.seats.contains(((ResourceLocation)Block.field_149771_c.func_177774_c((Object)block)).toString());
    }

    public boolean isSticky(Block block) {
        return this.shared.stickyObjects.contains(((ResourceLocation)Block.field_149771_c.func_177774_c((Object)block)).toString());
    }

    @SubscribeEvent
    public void onConfigChange(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("davincisvessels")) {
            if (this.config.hasChanged()) {
                this.config.save();
            }
            this.loadAndSave();
        }
    }

    public Configuration getConfig() {
        return this.config;
    }

    public SharedConfig getShared() {
        return this.shared;
    }

    public void setShared(SharedConfig shared) {
        this.shared = shared;
    }

    public class SharedConfig {
        public boolean enableAirShips;
        public boolean enableSubmersibles;
        public int shipEntitySyncRate;
        public int maxShipChunkBlocks;
        public float flyBalloonRatio;
        public float submersibleFillRatio;
        public int shipControlType;
        public float turnSpeed;
        public float speedLimit;
        public float bankingMultiplier;
        public boolean disassembleOnDismount;
        public boolean enginesMandatory;
        public Set<String> balloonAlternatives;
        public Set<String> seats;
        public Set<String> stickyObjects;
        public boolean enableShipDownfall;

        public NBTTagCompound serialize() {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74757_a("enableAirShips", this.enableAirShips);
            tag.func_74757_a("enableSubmersibles", this.enableSubmersibles);
            tag.func_74768_a("shipEntitySyncRate", this.shipEntitySyncRate);
            tag.func_74768_a("maxShipChunkBlocks", this.maxShipChunkBlocks);
            tag.func_74776_a("flyBalloonRatio", this.flyBalloonRatio);
            tag.func_74776_a("submersibleFillRatio", this.submersibleFillRatio);
            tag.func_74768_a("shipControlType", this.shipControlType);
            tag.func_74776_a("turnSpeed", this.turnSpeed);
            tag.func_74776_a("speedLimit", this.speedLimit);
            tag.func_74776_a("bankingMultiplier", this.bankingMultiplier);
            tag.func_74757_a("disassembleOnDismount", this.disassembleOnDismount);
            tag.func_74757_a("enginesMandatory", this.enginesMandatory);
            tag.func_74757_a("enableShipDownfall", this.enableShipDownfall);
            tag.func_74778_a("balloonAlternatives", new Gson().toJson(this.balloonAlternatives));
            tag.func_74778_a("seats", new Gson().toJson(this.seats));
            tag.func_74778_a("stickyObjects", new Gson().toJson(this.stickyObjects));
            return tag;
        }

        public SharedConfig deserialize(NBTTagCompound tag) {
            SharedConfig sharedConfig = new SharedConfig();
            sharedConfig.enableAirShips = tag.func_74767_n("enableAirShips");
            sharedConfig.enableSubmersibles = tag.func_74767_n("enableSubmersibles");
            sharedConfig.shipEntitySyncRate = tag.func_74762_e("shipEntitySyncRate");
            sharedConfig.maxShipChunkBlocks = tag.func_74762_e("maxShipChunkBlocks");
            sharedConfig.flyBalloonRatio = tag.func_74760_g("flyBalloonRatio");
            sharedConfig.submersibleFillRatio = tag.func_74760_g("submersibleFillRatio");
            sharedConfig.shipControlType = tag.func_74762_e("shipControlType");
            sharedConfig.turnSpeed = tag.func_74760_g("turnSpeed");
            sharedConfig.speedLimit = tag.func_74760_g("speedLimit");
            sharedConfig.bankingMultiplier = tag.func_74760_g("bankingMultiplier");
            sharedConfig.disassembleOnDismount = tag.func_74767_n("disassembleOnDismount");
            sharedConfig.enginesMandatory = tag.func_74767_n("enginesMandatory");
            sharedConfig.enableShipDownfall = tag.func_74767_n("enableShipDownfall");
            sharedConfig.balloonAlternatives = (Set)new Gson().fromJson(tag.func_74779_i("balloonAlternatives"), this.balloonAlternatives.getClass());
            sharedConfig.seats = (Set)new Gson().fromJson(tag.func_74779_i("seats"), this.seats.getClass());
            sharedConfig.stickyObjects = (Set)new Gson().fromJson(tag.func_74779_i("stickyObjects"), this.stickyObjects.getClass());
            return sharedConfig;
        }
    }
}

